/*
 * Decompiled with CFR 0.152.
 */
package space.earlygrey.shapedrawer;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.PolygonBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Matrix4;
import space.earlygrey.shapedrawer.BatchManager;
import space.earlygrey.shapedrawer.FilledPolygonDrawer;
import space.earlygrey.shapedrawer.LineDrawer;
import space.earlygrey.shapedrawer.PathDrawer;
import space.earlygrey.shapedrawer.PolygonBatchManager;
import space.earlygrey.shapedrawer.PolygonDrawer;

public abstract class AbstractShapeDrawer {
    final BatchManager batchManager;
    float defaultLineWidth = 1.0f;
    boolean defaultSnap = false;
    protected static final Matrix4 mat4 = new Matrix4();
    protected final LineDrawer lineDrawer;
    protected final PathDrawer pathDrawer;
    protected final PolygonDrawer polygonDrawer;
    protected final FilledPolygonDrawer filledPolygonDrawer;

    AbstractShapeDrawer(Batch batch, TextureRegion region) {
        if (batch instanceof PolygonBatch) {
            PolygonBatchManager manager = new PolygonBatchManager((PolygonBatch)batch, region);
            this.filledPolygonDrawer = new FilledPolygonDrawer.PolygonBatchFilledPolygonDrawer(manager, this);
            this.batchManager = manager;
        } else {
            this.batchManager = new BatchManager(batch, region);
            this.filledPolygonDrawer = new FilledPolygonDrawer.BatchFilledPolygonDrawer(this.batchManager, this);
        }
        this.lineDrawer = new LineDrawer(this.batchManager, this);
        this.pathDrawer = new PathDrawer(this.batchManager, this);
        this.polygonDrawer = new PolygonDrawer(this.batchManager, this);
    }

    public void update() {
        this.update(true);
    }

    public void update(boolean updatePixelSize) {
        if (updatePixelSize) {
            this.updatePixelSize();
        }
    }

    public float updatePixelSize() {
        Matrix4 trans = this.getBatch().getTransformMatrix();
        Matrix4 proj = this.getBatch().getProjectionMatrix();
        mat4.set(proj).mul(trans);
        float scaleX = mat4.getScaleX();
        float worldWidth = 2.0f / scaleX;
        float newPixelSize = worldWidth / (float)Gdx.graphics.getWidth();
        return this.setPixelSize(newPixelSize);
    }

    protected boolean isJoinNecessary(float lineWidth) {
        return lineWidth > 3.0f * this.getPixelSize();
    }

    protected int estimateSidesRequired(float radiusX, float radiusY) {
        float circumference = (float)(6.2831854820251465 * Math.sqrt((radiusX * radiusX + radiusY * radiusY) / 2.0f));
        int sides = (int)(circumference / (16.0f * this.getPixelSize()));
        float a = Math.min(radiusX, radiusY);
        float b = Math.max(radiusX, radiusY);
        float eccentricity = (float)Math.sqrt(1.0f - a * a / (b * b));
        sides = (int)((float)sides + (float)sides * eccentricity / 16.0f);
        return Math.max(sides, 20);
    }

    public float setPixelSize(float pixelSize) {
        return this.batchManager.setPixelSize(pixelSize);
    }

    public float getPixelSize() {
        return this.batchManager.getPixelSize();
    }

    public Batch getBatch() {
        return this.batchManager.getBatch();
    }

    public TextureRegion getRegion() {
        return this.batchManager.getRegion();
    }

    public float getDefaultLineWidth() {
        return this.defaultLineWidth;
    }

    public float setDefaultLineWidth(float defaultLineWidth) {
        float oldWidth = this.defaultLineWidth;
        this.defaultLineWidth = defaultLineWidth;
        return oldWidth;
    }

    public boolean isDefaultSnap() {
        return this.defaultSnap;
    }

    public boolean setDefaultSnap(boolean defaultSnap) {
        boolean oldSnap = this.defaultSnap;
        this.defaultSnap = defaultSnap;
        return oldSnap;
    }

    public TextureRegion setTextureRegion(TextureRegion region) {
        return this.batchManager.setTextureRegion(region);
    }

    public float setColor(Color color) {
        return this.setColor(color.toFloatBits());
    }

    public float setColor(float floatBits) {
        return this.batchManager.setColor(floatBits);
    }

    public float getPackedColor() {
        return this.batchManager.getPackedColor();
    }

    public float setColor(float r, float g, float b, float a) {
        return this.setColor(Color.toFloatBits((float)r, (float)g, (float)b, (float)a));
    }
}

