/*
 * Decompiled with CFR 0.152.
 */
package space.earlygrey.shapedrawer;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.PolygonBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Polygon;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.utils.ShortArray;
import space.earlygrey.shapedrawer.FilledPolygonDrawer;
import space.earlygrey.shapedrawer.ShapeDrawer;

public class PolygonShapeDrawer
extends ShapeDrawer {
    protected final FilledPolygonDrawer filledPolygonDrawer;
    short[] triangles;
    int triangleOffset = 0;
    final int TRIANGLE_PUSH_SIZE = 15;

    public PolygonShapeDrawer(PolygonBatch batch, TextureRegion region) {
        super((Batch)batch, region);
        int trianglesLength = (int)Math.ceil((double)(this.verts.length / 5) * 1.5);
        this.triangles = new short[trianglesLength];
        this.filledPolygonDrawer = new FilledPolygonDrawer(this);
    }

    public PolygonBatch getBatch() {
        return (PolygonBatch)super.getBatch();
    }

    @Override
    protected void pushQuad() {
        int vertexOffset = this.vertexCount;
        this.triangles[this.triangleOffset++] = (short)(vertexOffset + 0);
        this.triangles[this.triangleOffset++] = (short)(vertexOffset + 1);
        this.triangles[this.triangleOffset++] = (short)(vertexOffset + 2);
        this.triangles[this.triangleOffset++] = (short)(vertexOffset + 0);
        this.triangles[this.triangleOffset++] = (short)(vertexOffset + 2);
        this.triangles[this.triangleOffset++] = (short)(vertexOffset + 3);
        super.pushQuad();
    }

    @Override
    protected void pushTriangle() {
        int vertexOffset = this.vertexCount;
        this.triangles[this.triangleOffset++] = (short)(vertexOffset + 0);
        this.triangles[this.triangleOffset++] = (short)(vertexOffset + 1);
        this.triangles[this.triangleOffset++] = (short)(vertexOffset + 2);
        int i = this.getArrayOffset();
        this.verts[i + 3] = this.r.getU();
        this.verts[i + 4] = this.r.getV();
        this.verts[i + 8] = this.r.getU2();
        this.verts[i + 9] = this.r.getV();
        this.verts[i + 13] = this.r.getU2();
        this.verts[i + 14] = this.r.getV2();
        this.verts[i + 2] = this.floatBits;
        this.verts[i + 7] = this.floatBits;
        this.verts[i + 12] = this.floatBits;
        this.vertexCount += 15;
        if (!this.isCachingDraws() || this.isCacheFull()) {
            this.drawVerts();
        }
    }

    @Override
    protected void drawVerts() {
        if (this.vertexCount == 0) {
            return;
        }
        this.getBatch().draw(this.r.getTexture(), this.verts, 0, this.getArrayOffset(), this.triangles, 0, this.triangleOffset);
        this.vertexCount = 0;
        this.triangleOffset = 0;
    }

    public void filledCircle(float centreX, float centreY, float radius) {
        this.filledEllipse(centreX, centreY, radius, radius, 0.0f);
    }

    public void filledEllipse(float centreX, float centreY, float radiusX, float radiusY) {
        this.filledEllipse(centreX, centreY, radiusX, radiusY, 0.0f);
    }

    public void filledEllipse(float centreX, float centreY, float radiusX, float radiusY, float rotation) {
        this.filledPolygonDrawer.polygon(centreX, centreY, this.estimateSidesRequired(radiusX, radiusY), radiusX, radiusY, rotation, 0.0f, (float)Math.PI * 2);
    }

    public void sector(float centreX, float centreY, float radius, float startAngle, float radians) {
        this.sector(centreX, centreY, radius, startAngle, radians, this.estimateSidesRequired(radius, radius));
    }

    public void sector(float centreX, float centreY, float radius, float startAngle, float radians, int sides) {
        this.filledPolygonDrawer.polygon(centreX, centreY, sides, radius, radius, 0.0f, startAngle, radians);
    }

    public void filledPolygon(float centreX, float centreY, int sides, float scale) {
        this.filledPolygon(centreX, centreY, sides, scale, scale, 0.0f);
    }

    public void filledPolygon(float centreX, float centreY, int sides, float radius, float rotation) {
        this.filledPolygon(centreX, centreY, sides, radius, radius, rotation);
    }

    public void filledPolygon(float centreX, float centreY, int sides, float scaleX, float scaleY, float rotation) {
        this.filledPolygonDrawer.polygon(centreX, centreY, sides, scaleX, scaleY, rotation, 0.0f, (float)Math.PI * 2);
    }

    public void filledPolygon(Polygon polygon) {
        this.filledPolygon(polygon.getTransformedVertices());
    }

    public void filledPolygon(float[] vertices) {
        this.filledPolygonDrawer.polygon(vertices);
    }

    public void filledPolygon(Polygon polygon, short[] triangles) {
        this.filledPolygon(polygon.getTransformedVertices(), triangles);
    }

    public void filledPolygon(float[] vertices, short[] triangles) {
        this.filledPolygonDrawer.polygon(vertices, triangles);
    }

    public void filledPolygon(Polygon polygon, ShortArray triangles) {
        this.filledPolygon(polygon.getTransformedVertices(), triangles);
    }

    public void filledPolygon(float[] vertices, ShortArray triangles) {
        this.filledPolygonDrawer.polygon(vertices, triangles);
    }

    public void filledRectangle(Rectangle rect) {
        this.rectangle(rect.x, rect.y, rect.width, rect.height);
    }

    public void filledRectangle(Rectangle rect, Color color) {
        this.filledRectangle(rect.x, rect.y, rect.width, rect.height, color);
    }

    public void filledRectangle(float x, float y, float width, float height) {
        this.filledRectangle(x, y, width, height, 0.0f);
    }

    public void filledRectangle(float x, float y, float width, float height, Color color) {
        float oldColor = this.setColor(color);
        this.filledRectangle(x, y, width, height);
        this.setColor(oldColor);
    }

    public void filledRectangle(float x, float y, float width, float height, float rotation) {
        this.filledPolygonDrawer.rectangle(x, y, width, height, rotation);
    }
}

