/*
 * Decompiled with CFR 0.152.
 */
package space.earlygrey.shapedrawer;

import com.badlogic.gdx.math.EarClippingTriangulator;
import com.badlogic.gdx.utils.ShortArray;
import space.earlygrey.shapedrawer.DrawerTemplate;
import space.earlygrey.shapedrawer.ShapeDrawer;
import space.earlygrey.shapedrawer.ShapeUtils;

public class FilledPolygonDrawer
extends DrawerTemplate {
    static final EarClippingTriangulator triangulator = new EarClippingTriangulator();

    FilledPolygonDrawer(ShapeDrawer drawer) {
        super(drawer);
    }

    void polygon(float centreX, float centreY, int sides, float radiusX, float radiusY, float rotation, float startAngle, float radians) {
        if ((radians = ShapeUtils.normaliseAngleToPositive(radians)) == 0.0f) {
            radians = (float)Math.PI * 2;
            startAngle = 0.0f;
        }
        boolean wasCaching = this.drawer.startCaching();
        float angleInterval = (float)Math.PI * 2 / (float)sides;
        float endAngle = startAngle + radians;
        float cos = (float)Math.cos(angleInterval);
        float sin = (float)Math.sin(angleInterval);
        float cosRot = (float)Math.cos(rotation);
        float sinRot = (float)Math.sin(rotation);
        int start = (int)Math.ceil((float)sides * (startAngle / ((float)Math.PI * 2)));
        int end = (int)Math.floor((float)sides * (endAngle / ((float)Math.PI * 2))) + 1;
        dir.set(1.0f, 0.0f).rotateRad(Math.min((float)start * angleInterval, endAngle));
        A.set(1.0f, 0.0f).rotateRad(startAngle).scl(radiusX, radiusY);
        B.set(dir).scl(radiusX, radiusY);
        for (int i = start; i <= end; ++i) {
            this.x1(FilledPolygonDrawer.A.x * cosRot - FilledPolygonDrawer.A.y * sinRot + centreX);
            this.y1(FilledPolygonDrawer.A.x * sinRot + FilledPolygonDrawer.A.y * cosRot + centreY);
            this.x2(FilledPolygonDrawer.B.x * cosRot - FilledPolygonDrawer.B.y * sinRot + centreX);
            this.y2(FilledPolygonDrawer.B.x * sinRot + FilledPolygonDrawer.B.y * cosRot + centreY);
            this.x3(centreX);
            this.y3(centreY);
            this.drawer.pushTriangle();
            if (i < end - 1) {
                A.set(B);
                dir.set(FilledPolygonDrawer.dir.x * cos - FilledPolygonDrawer.dir.y * sin, FilledPolygonDrawer.dir.x * sin + FilledPolygonDrawer.dir.y * cos);
                B.set(dir).scl(radiusX, radiusY);
                continue;
            }
            if (i != end - 1) continue;
            A.set(B);
            B.set(1.0f, 0.0f).rotateRad(endAngle).scl(radiusX, radiusY);
        }
        if (!wasCaching) {
            this.drawer.endCaching();
        }
    }

    void polygon(float[] vertices) {
        ShortArray triangles = triangulator.computeTriangles(vertices);
        this.polygon(vertices, triangles);
    }

    void polygon(float[] vertices, ShortArray triangles) {
        for (int i = 0; i < triangles.size; i += 3) {
            this.vert1(vertices[2 * triangles.get(i)], vertices[2 * triangles.get(i) + 1]);
            this.vert2(vertices[2 * triangles.get(i + 1)], vertices[2 * triangles.get(i + 1) + 1]);
            this.vert3(vertices[2 * triangles.get(i + 2)], vertices[2 * triangles.get(i + 2) + 1]);
            this.drawer.pushTriangle();
        }
    }

    void polygon(float[] vertices, short[] triangles) {
        for (int i = 0; i < triangles.length; i += 3) {
            this.vert1(vertices[2 * triangles[i]], vertices[2 * triangles[i] + 1]);
            this.vert2(vertices[2 * triangles[i + 1]], vertices[2 * triangles[i + 1] + 1]);
            this.vert3(vertices[2 * triangles[i + 2]], vertices[2 * triangles[i + 2] + 1]);
            this.drawer.pushTriangle();
        }
    }

    void rectangle(float x, float y, float width, float height, float rotation) {
        float cos = (float)Math.cos(rotation);
        float sin = (float)Math.sin(rotation);
        float halfWidth = 0.5f * width;
        float halfHeight = 0.5f * height;
        float centreX = x + halfWidth;
        float centreY = y + halfHeight;
        this.x1(halfWidth * cos - halfHeight * sin + centreX);
        this.y1(halfWidth * sin + halfHeight * cos + centreY);
        this.x2(-halfWidth * cos - halfHeight * sin + centreX);
        this.y2(-halfWidth * sin + halfHeight * cos + centreY);
        this.x3(-halfWidth * cos - -halfHeight * sin + centreX);
        this.y3(-halfWidth * sin + -halfHeight * cos + centreY);
        this.x4(halfWidth * cos - -halfHeight * sin + centreX);
        this.y4(halfWidth * sin + -halfHeight * cos + centreY);
        this.drawer.pushQuad();
    }
}

