/*
 * Decompiled with CFR 0.152.
 */
package space.earlygrey.shapedrawer;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Matrix4;

public abstract class AbstractShapeDrawer {
    protected final Batch batch;
    protected TextureRegion r;
    protected float floatBits;
    protected final float[] verts = new float[2000];
    protected int vertexCount;
    protected float pixelSize = 1.0f;
    protected float halfPixelSize = 0.5f * this.pixelSize;
    protected float offset = 0.001f * this.pixelSize;
    protected float defaultLineWidth = this.pixelSize;
    protected boolean defaultSnap = false;
    protected boolean cacheDraws = false;
    protected static final Matrix4 mat4 = new Matrix4();
    protected final int VERTEX_SIZE;
    protected final int VERTICES_PER_PUSH;
    protected final int PUSH_SIZE;

    protected AbstractShapeDrawer(Batch batch, TextureRegion region) {
        this(batch, region, 5, 4);
    }

    protected AbstractShapeDrawer(Batch batch, TextureRegion region, int vertexSize, int verticesPerPush) {
        this.batch = batch;
        this.setTextureRegion(region);
        this.setColor(Color.WHITE);
        this.VERTEX_SIZE = vertexSize;
        this.VERTICES_PER_PUSH = verticesPerPush;
        this.PUSH_SIZE = this.VERTICES_PER_PUSH * this.VERTEX_SIZE;
    }

    public void update() {
        this.update(true);
    }

    public void update(boolean updatePixelSize) {
        if (updatePixelSize) {
            this.updatePixelSize();
        }
    }

    public float updatePixelSize() {
        Matrix4 trans = this.getBatch().getTransformMatrix();
        Matrix4 proj = this.getBatch().getProjectionMatrix();
        mat4.set(proj).mul(trans);
        float scaleX = mat4.getScaleX();
        float worldWidth = 2.0f / scaleX;
        float newPixelSize = worldWidth / (float)Gdx.graphics.getWidth();
        return this.setPixelSize(newPixelSize);
    }

    protected boolean isJoinNecessary(float lineWidth) {
        return lineWidth > 3.0f * this.pixelSize;
    }

    protected int estimateSidesRequired(float radiusX, float radiusY) {
        float circumference = (float)(6.2831854820251465 * Math.sqrt((radiusX * radiusX + radiusY * radiusY) / 2.0f));
        int sides = (int)(circumference / (16.0f * this.pixelSize));
        float a = Math.min(radiusX, radiusY);
        float b = Math.max(radiusX, radiusY);
        float eccentricity = (float)Math.sqrt(1.0f - a * a / (b * b));
        sides = (int)((float)sides + (float)sides * eccentricity / 16.0f);
        return Math.max(sides, 20);
    }

    public float setPixelSize(float pixelSize) {
        float oldPixelSize = this.pixelSize;
        this.pixelSize = pixelSize;
        this.halfPixelSize = 0.5f * pixelSize;
        this.offset = 0.001f * pixelSize;
        return oldPixelSize;
    }

    public float getPixelSize() {
        return this.pixelSize;
    }

    public Batch getBatch() {
        return this.batch;
    }

    public TextureRegion getRegion() {
        return this.r;
    }

    public float getDefaultLineWidth() {
        return this.defaultLineWidth;
    }

    public float setDefaultLineWidth(float defaultLineWidth) {
        float oldWidth = this.defaultLineWidth;
        this.defaultLineWidth = defaultLineWidth;
        return oldWidth;
    }

    public boolean isDefaultSnap() {
        return this.defaultSnap;
    }

    public boolean setDefaultSnap(boolean defaultSnap) {
        boolean oldSnap = this.defaultSnap;
        this.defaultSnap = defaultSnap;
        return oldSnap;
    }

    public TextureRegion setTextureRegion(TextureRegion region) {
        TextureRegion oldRegion = this.r;
        this.r = region;
        return oldRegion;
    }

    public float setColor(Color color) {
        return this.setColor(color.toFloatBits());
    }

    public float setColor(float floatBits) {
        float oldColor = this.getPackedColor();
        this.floatBits = floatBits;
        return oldColor;
    }

    public float getPackedColor() {
        return this.floatBits;
    }

    protected boolean isCachingDraws() {
        return this.cacheDraws;
    }

    protected boolean startCaching() {
        boolean wasCaching = this.isCachingDraws();
        this.cacheDraws = true;
        return wasCaching;
    }

    protected void endCaching() {
        this.cacheDraws = false;
        if (this.vertexCount > 0) {
            this.drawVerts();
        }
    }

    protected void pushVerts() {
        int i = this.getArrayOffset();
        this.verts[i + 3] = this.r.getU();
        this.verts[i + 4] = this.r.getV();
        this.verts[i + 8] = this.r.getU2();
        this.verts[i + 9] = this.r.getV();
        this.verts[i + 13] = this.r.getU2();
        this.verts[i + 14] = this.r.getV2();
        this.verts[i + 18] = this.r.getU();
        this.verts[i + 19] = this.r.getV2();
        this.verts[i + 2] = this.floatBits;
        this.verts[i + 7] = this.floatBits;
        this.verts[i + 12] = this.floatBits;
        this.verts[i + 17] = this.floatBits;
        this.vertexCount += this.VERTICES_PER_PUSH;
        if (!this.isCachingDraws() || this.isCacheFull()) {
            this.drawVerts();
        }
    }

    protected boolean isCacheFull() {
        return this.verts.length - this.PUSH_SIZE < this.PUSH_SIZE * this.vertexCount;
    }

    protected void drawVerts() {
        if (this.vertexCount == 0) {
            return;
        }
        this.batch.draw(this.r.getTexture(), this.verts, 0, this.getArrayOffset());
        this.vertexCount = 0;
    }

    protected int getArrayOffset() {
        return this.VERTEX_SIZE * this.vertexCount;
    }

    protected void x1(float x1) {
        this.verts[this.getArrayOffset() + 0] = x1;
    }

    protected void y1(float y1) {
        this.verts[this.getArrayOffset() + 1] = y1;
    }

    protected void x2(float x2) {
        this.verts[this.getArrayOffset() + 5] = x2;
    }

    protected void y2(float y2) {
        this.verts[this.getArrayOffset() + 6] = y2;
    }

    protected void x3(float x3) {
        this.verts[this.getArrayOffset() + 10] = x3;
    }

    protected void y3(float y3) {
        this.verts[this.getArrayOffset() + 11] = y3;
    }

    protected void x4(float x4) {
        this.verts[this.getArrayOffset() + 15] = x4;
    }

    protected void y4(float y4) {
        this.verts[this.getArrayOffset() + 16] = y4;
    }

    protected float x1() {
        return this.verts[this.getArrayOffset() + 0];
    }

    protected float y1() {
        return this.verts[this.getArrayOffset() + 1];
    }

    protected float x2() {
        return this.verts[this.getArrayOffset() + 5];
    }

    protected float y2() {
        return this.verts[this.getArrayOffset() + 6];
    }

    protected float x3() {
        return this.verts[this.getArrayOffset() + 10];
    }

    protected float y3() {
        return this.verts[this.getArrayOffset() + 11];
    }

    protected float x4() {
        return this.verts[this.getArrayOffset() + 15];
    }

    protected float y4() {
        return this.verts[this.getArrayOffset() + 16];
    }
}

