/*
 * Decompiled with CFR 0.152.
 */
package space.earlygrey.shapedrawer;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.FloatArray;
import space.earlygrey.shapedrawer.DrawerTemplate;
import space.earlygrey.shapedrawer.JoinType;
import space.earlygrey.shapedrawer.Joiner;
import space.earlygrey.shapedrawer.ShapeDrawer;
import space.earlygrey.shapedrawer.ShapeUtils;

class PathDrawer
extends DrawerTemplate {
    FloatArray path = new FloatArray();
    FloatArray tempPath = new FloatArray();
    static final Vector2 D0 = new Vector2();
    static final Vector2 E0 = new Vector2();

    PathDrawer(ShapeDrawer drawer) {
        super(drawer);
    }

    <T extends Vector2> void path(Array<T> userPath, float lineWidth, JoinType joinType) {
        this.path(userPath, lineWidth, joinType, true);
    }

    <T extends Vector2> void path(Array<T> userPath, float lineWidth, JoinType joinType, boolean open) {
        for (int i = 0; i < userPath.size; ++i) {
            Vector2 v = (Vector2)userPath.get(i);
            this.tempPath.add(v.x, v.y);
        }
        this.path(this.tempPath.items, 0, this.tempPath.size, lineWidth, joinType, open);
        this.tempPath.clear();
    }

    void path(float[] userPath, float lineWidth, JoinType joinType) {
        this.path(userPath, 0, userPath.length, lineWidth, joinType);
    }

    void path(float[] userPath, float lineWidth, JoinType joinType, boolean open) {
        this.path(userPath, 0, userPath.length, lineWidth, joinType, open);
    }

    void path(float[] userPath, int start, int end, float lineWidth, JoinType joinType) {
        this.path(userPath, start, end, lineWidth, joinType, true);
    }

    void path(float[] userPath, int start, int end, float lineWidth, JoinType joinType, boolean open) {
        if (userPath.length < 4) {
            return;
        }
        this.path.add(userPath[start]);
        this.path.add(userPath[start + 1]);
        for (int i = start + 2; i < end; i += 2) {
            if (ShapeUtils.epsilonEquals(userPath[i - 2], userPath[i]) || ShapeUtils.epsilonEquals(userPath[i - 1], userPath[i + 1])) continue;
            this.path.add(userPath[i], userPath[i + 1]);
        }
        if (this.path.size < 4) {
            this.path.clear();
            return;
        }
        if (this.path.size == 4) {
            this.drawer.line(this.path.items[0], this.path.items[1], this.path.items[2], this.path.items[3], lineWidth);
            this.path.clear();
            return;
        }
        switch (joinType) {
            case NONE: {
                this.drawPathNoJoin(this.path.items, this.path.size, lineWidth, open);
                break;
            }
            case SMOOTH: {
                this.drawPathSmoothJoin(this.path.items, this.path.size, lineWidth, open);
                break;
            }
            case POINTY: {
                this.drawPathPointyJoin(this.path.items, this.path.size, lineWidth, open);
            }
        }
        this.path.clear();
    }

    void drawPathNoJoin(float[] path, int size, float lineWidth, boolean open) {
        int n = open ? size - 2 : size;
        for (int i = 0; i < n; i += 2) {
            this.drawer.line(path[i], path[i + 1], path[(i + 2) % size], path[(i + 3) % size], lineWidth);
        }
    }

    void drawPathPointyJoin(float[] path, int size, float lineWidth, boolean open) {
        float halfLineWidth = 0.5f * lineWidth;
        for (int i = 2; i < size - 2; i += 2) {
            A.set(path[i - 2], path[i - 1]);
            B.set(path[i], path[i + 1]);
            C.set(path[i + 2], path[i + 3]);
            Joiner.preparePointyJoin(A, B, C, D, E, halfLineWidth);
            this.vert3(D);
            this.vert4(E);
            if (i == 2) {
                if (open) {
                    Joiner.prepareFlatEndpoint(path[2], path[3], path[0], path[1], D, E, halfLineWidth);
                    this.vert1(E);
                    this.vert2(D);
                } else {
                    vec1.set(path[size - 2], path[size - 1]);
                    Joiner.preparePointyJoin(vec1, A, B, D0, E0, halfLineWidth);
                    this.vert1(E0);
                    this.vert2(D0);
                }
            }
            this.drawVerts();
            this.vert1(this.x4(), this.y4());
            this.vert2(this.x3(), this.y3());
        }
        if (open) {
            Joiner.prepareFlatEndpoint(B, C, D, E, halfLineWidth);
            this.vert1(D);
            this.vert2(E);
            this.drawVerts();
        } else {
            A.set(path[0], path[1]);
            Joiner.preparePointyJoin(B, C, A, D, E, halfLineWidth);
            this.vert1(E);
            this.vert2(D);
            this.drawVerts();
            this.vert3(D0);
            this.vert4(E0);
            this.drawVerts();
        }
    }

    void drawPathSmoothJoin(float[] path, int size, float lineWidth, boolean open) {
        float halfLineWidth = 0.5f * lineWidth;
        A.set(path[0], path[1]);
        B.set(path[2], path[3]);
        C.set(path[4], path[5]);
        for (int i = 4; i < size; i += 2) {
            Joiner.prepareSmoothJoin(A, B, C, D, E, halfLineWidth, false);
            this.vert3(E);
            this.vert4(D);
            if (i == 4) {
                if (open) {
                    Joiner.prepareFlatEndpoint(B, A, D, E, halfLineWidth);
                } else {
                    vec1.set(path[size - 2], path[size - 1]);
                    Joiner.prepareSmoothJoin(vec1, A, B, D0, E0, halfLineWidth, false);
                    Joiner.prepareSmoothJoin(vec1, A, B, D, E, halfLineWidth, true);
                }
                this.vert1(D);
                this.vert2(E);
            }
            this.drawVerts();
            this.drawSmoothJoinFill(A, B, C, D, E, halfLineWidth);
            Joiner.prepareSmoothJoin(A, B, C, D, E, halfLineWidth, true);
            this.vert1(D);
            this.vert2(E);
            if (i >= size - 2) continue;
            A.set(path[i - 2], path[i - 1]);
            B.set(path[i], path[i + 1]);
            C.set(path[i + 2], path[i + 3]);
        }
        if (open) {
            Joiner.prepareFlatEndpoint(B, C, D, E, halfLineWidth);
            this.vert3(D);
            this.vert4(E);
            this.drawVerts();
        } else {
            A.set(B);
            B.set(C);
            C.set(path[0], path[1]);
            Joiner.prepareSmoothJoin(A, B, C, D, E, halfLineWidth, false);
            this.vert3(E);
            this.vert4(D);
            this.drawVerts();
            this.drawSmoothJoinFill(A, B, C, D, E, halfLineWidth);
            Joiner.prepareSmoothJoin(A, B, C, D, E, halfLineWidth, true);
            this.vert3(E);
            this.vert4(D);
            this.vert1(D0);
            this.vert2(E0);
            this.drawVerts();
            A.set(path[2], path[3]);
            this.drawSmoothJoinFill(B, C, A, D0, E0, halfLineWidth);
        }
    }
}

