/*
 * Decompiled with CFR 0.152.
 */
package space.earlygrey.shapedrawer;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.Vector2;
import space.earlygrey.shapedrawer.Joiner;
import space.earlygrey.shapedrawer.ShapeDrawer;

abstract class DrawerTemplate {
    static final Vector2 A = new Vector2();
    static final Vector2 B = new Vector2();
    static final Vector2 C = new Vector2();
    static final Vector2 D = new Vector2();
    static final Vector2 E = new Vector2();
    static final Vector2 dir = new Vector2();
    static final Vector2 vec1 = new Vector2();
    static final Vector2 vec2 = new Vector2();
    static final Vector2 vec3 = new Vector2();
    final ShapeDrawer drawer;

    DrawerTemplate(ShapeDrawer drawer) {
        this.drawer = drawer;
    }

    void drawVerts() {
        this.drawer.drawVerts();
    }

    void drawSmoothJoinFill(Vector2 A, Vector2 B, Vector2 C, Vector2 D, Vector2 E, float halfLineWidth) {
        boolean bendsLeft = Joiner.prepareSmoothJoin(A, B, C, D, E, halfLineWidth, false);
        this.vert1(bendsLeft ? E : D);
        this.vert2(bendsLeft ? D : E);
        bendsLeft = Joiner.prepareSmoothJoin(A, B, C, D, E, halfLineWidth, true);
        this.vert3(bendsLeft ? E : D);
        this.vert4(this.x3(), this.y3());
        this.drawVerts();
    }

    void drawSmoothJoinFill(Vector2 A, Vector2 B, Vector2 C, Vector2 D, Vector2 E, Vector2 offset, float cos, float sin, float halfLineWidth) {
        boolean bendsLeft = Joiner.prepareSmoothJoin(A, B, C, D, E, halfLineWidth, false);
        Vector2 V1 = bendsLeft ? E : D;
        Vector2 V2 = bendsLeft ? D : E;
        this.vert1(V1.x * cos - V1.y * sin + offset.x, V1.x * sin + V1.y * cos + offset.y);
        this.vert2(V2.x * cos - V2.y * sin + offset.x, V2.x * sin + V2.y * cos + offset.y);
        bendsLeft = Joiner.prepareSmoothJoin(A, B, C, D, E, halfLineWidth, true);
        Vector2 V3 = bendsLeft ? E : D;
        float x = V3.x * cos - V3.y * sin + offset.x;
        float y = V3.x * sin + V3.y * cos + offset.y;
        this.vert3(x, y);
        this.vert4(x, y);
        this.drawVerts();
    }

    void x1(float x1) {
        this.drawer.x1(x1);
    }

    void y1(float y1) {
        this.drawer.y1(y1);
    }

    void x2(float x2) {
        this.drawer.x2(x2);
    }

    void y2(float y2) {
        this.drawer.y2(y2);
    }

    void x3(float x3) {
        this.drawer.x3(x3);
    }

    void y3(float y3) {
        this.drawer.y3(y3);
    }

    void x4(float x4) {
        this.drawer.x4(x4);
    }

    void y4(float y4) {
        this.drawer.y4(y4);
    }

    void vert1(float x, float y) {
        this.x1(x);
        this.y1(y);
    }

    void vert2(float x, float y) {
        this.x2(x);
        this.y2(y);
    }

    void vert3(float x, float y) {
        this.x3(x);
        this.y3(y);
    }

    void vert4(float x, float y) {
        this.x4(x);
        this.y4(y);
    }

    void vert1(Vector2 V) {
        this.vert1(V.x, V.y);
    }

    void vert2(Vector2 V) {
        this.vert2(V.x, V.y);
    }

    void vert3(Vector2 V) {
        this.vert3(V.x, V.y);
    }

    void vert4(Vector2 V) {
        this.vert4(V.x, V.y);
    }

    void vert1(Vector2 V, Vector2 offset) {
        this.vert1(V.x + offset.x, V.y + offset.y);
    }

    void vert2(Vector2 V, Vector2 offset) {
        this.vert2(V.x + offset.x, V.y + offset.y);
    }

    void vert3(Vector2 V, Vector2 offset) {
        this.vert3(V.x + offset.x, V.y + offset.y);
    }

    void vert4(Vector2 V, Vector2 offset) {
        this.vert4(V.x + offset.x, V.y + offset.y);
    }

    float x1() {
        return this.drawer.x1();
    }

    float y1() {
        return this.drawer.y1();
    }

    float x2() {
        return this.drawer.x2();
    }

    float y2() {
        return this.drawer.y2();
    }

    float x3() {
        return this.drawer.x3();
    }

    float y3() {
        return this.drawer.y3();
    }

    float x4() {
        return this.drawer.x4();
    }

    float y4() {
        return this.drawer.y4();
    }

    void print1234() {
        System.out.println("(" + this.x1() + "," + this.y1() + ")  (" + this.x2() + "," + this.y2() + ")  (" + this.x3() + "," + this.y3() + ")  (" + this.x4() + "," + this.y4() + ")");
    }

    void draw1234() {
        float s = 3.0f;
        float c = this.drawer.getPackedColor();
        this.drawer.getBatch().setColor(Color.GREEN);
        this.drawer.getBatch().draw(this.drawer.getRegion(), this.x1() - s, this.y1() - s, 2.0f * s, 2.0f * s);
        this.drawer.getBatch().setColor(Color.ORANGE);
        this.drawer.getBatch().draw(this.drawer.getRegion(), this.x2() - s, this.y2() - s, 2.0f * s, 2.0f * s);
        this.drawer.getBatch().setColor(Color.YELLOW);
        this.drawer.getBatch().draw(this.drawer.getRegion(), this.x3() - s, this.y3() - s, 2.0f * s, 2.0f * s);
        this.drawer.getBatch().setColor(Color.PURPLE);
        this.drawer.getBatch().draw(this.drawer.getRegion(), this.x4() - s, this.y4() - s, 2.0f * s, 2.0f * s);
        this.drawer.setColor(c);
    }

    void drawABC() {
        this.drawABC(Vector2.Zero);
    }

    void drawABC(Vector2 offset) {
        float s1 = 4.0f;
        float s2 = 3.0f;
        float s3 = 2.0f;
        float c = this.drawer.getPackedColor();
        this.drawer.getBatch().setColor(Color.GREEN);
        this.drawer.getBatch().draw(this.drawer.getRegion(), DrawerTemplate.A.x - s1 + offset.x, DrawerTemplate.A.y - s1 + offset.y, 2.0f * s1, 2.0f * s1);
        this.drawer.getBatch().setColor(Color.ORANGE);
        this.drawer.getBatch().draw(this.drawer.getRegion(), DrawerTemplate.B.x - s2 + offset.x, DrawerTemplate.B.y - s2 + offset.y, 2.0f * s2, 2.0f * s2);
        this.drawer.getBatch().setColor(Color.YELLOW);
        this.drawer.getBatch().draw(this.drawer.getRegion(), DrawerTemplate.C.x - s3 + offset.x, DrawerTemplate.C.y - s3 + offset.y, 2.0f * s3, 2.0f * s3);
        this.drawer.setColor(c);
    }

    void drawDE(boolean scheme1) {
        float s = 2.0f;
        float c = this.drawer.getPackedColor();
        this.drawer.getBatch().setColor(scheme1 ? Color.YELLOW : Color.CHARTREUSE);
        this.drawer.getBatch().draw(this.drawer.getRegion(), DrawerTemplate.D.x - s, DrawerTemplate.D.y - s, 2.0f * s, 2.0f * s);
        this.drawer.getBatch().setColor(scheme1 ? Color.PINK : Color.TAN);
        this.drawer.getBatch().draw(this.drawer.getRegion(), DrawerTemplate.E.x - s, DrawerTemplate.E.y - s, 2.0f * s, 2.0f * s);
        this.drawer.setColor(c);
    }

    void drawDE() {
        this.drawDE(true);
    }
}

