/*
 * Decompiled with CFR 0.152.
 */
package space.earlygrey.shapedrawer;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Polygon;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Array;
import space.earlygrey.shapedrawer.AbstractShapeDrawer;
import space.earlygrey.shapedrawer.JoinType;
import space.earlygrey.shapedrawer.LineDrawer;
import space.earlygrey.shapedrawer.PathDrawer;
import space.earlygrey.shapedrawer.PolygonDrawer;

public class ShapeDrawer
extends AbstractShapeDrawer {
    protected final LineDrawer lineDrawer = new LineDrawer(this);
    protected final PathDrawer pathDrawer = new PathDrawer(this);
    protected final PolygonDrawer polygonDrawer = new PolygonDrawer(this);

    public ShapeDrawer(Batch batch, TextureRegion region) {
        super(batch, region);
    }

    public void line(Vector2 s, Vector2 e) {
        this.line(s.x, s.y, e.x, e.y, this.defaultLineWidth);
    }

    public void line(Vector2 s, Vector2 e, float lineWidth) {
        this.line(s.x, s.y, e.x, e.y, lineWidth);
    }

    public void line(Vector2 s, Vector2 e, Color color) {
        float c = this.setColor(color);
        this.line(s.x, s.y, e.x, e.y, this.defaultLineWidth);
        this.setColor(c);
    }

    public void line(Vector2 s, Vector2 e, Color color, float lineWidth) {
        float c = this.setColor(color);
        this.line(s.x, s.y, e.x, e.y, color, lineWidth);
        this.setColor(c);
    }

    public void line(float x1, float y1, float x2, float y2) {
        this.line(x1, y1, x2, y2, this.defaultLineWidth);
    }

    public void line(float x1, float y1, float x2, float y2, Color color) {
        this.line(x1, y1, x2, y2, color, this.defaultLineWidth);
    }

    public void line(float x1, float y1, float x2, float y2, Color color, float lineWidth) {
        float c = this.setColor(color);
        this.line(x1, y1, x2, y2, lineWidth);
        this.setColor(c);
    }

    public void line(float x1, float y1, float x2, float y2, float lineWidth) {
        this.line(x1, y1, x2, y2, lineWidth, this.defaultSnap);
    }

    public void line(float x1, float y1, float x2, float y2, float lineWidth, boolean snap) {
        this.lineDrawer.line(x1, y1, x2, y2, lineWidth, snap);
    }

    public void path(Array<Vector2> path) {
        this.path(path, this.defaultLineWidth);
    }

    public void path(Array<Vector2> path, JoinType joinType) {
        this.path(path, this.defaultLineWidth, joinType, true);
    }

    public void path(Array<Vector2> path, float lineWidth) {
        this.path(path, lineWidth, true);
    }

    public void path(Array<Vector2> path, float lineWidth, boolean open) {
        this.path(path, lineWidth, this.isJoinNecessary(lineWidth) ? JoinType.SMOOTH : JoinType.NONE, open);
    }

    public void path(Array<Vector2> path, float lineWidth, JoinType joinType, boolean open) {
        this.pathDrawer.path(path, lineWidth, joinType, open);
    }

    public void circle(float centreX, float centreY, float radius) {
        this.circle(centreX, centreY, radius, this.defaultLineWidth);
    }

    public void circle(float centreX, float centreY, float radius, JoinType jointType) {
        this.circle(centreX, centreY, radius, this.defaultLineWidth, jointType);
    }

    public void circle(float centreX, float centreY, float radius, float lineWidth) {
        this.circle(centreX, centreY, radius, lineWidth, this.isJoinNecessary(lineWidth) ? JoinType.SMOOTH : JoinType.NONE);
    }

    public void circle(float centreX, float centreY, float radius, float lineWidth, JoinType joinType) {
        this.ellipse(centreX, centreY, radius, radius, 0.0f, lineWidth, joinType);
    }

    public void ellipse(float centreX, float centreY, float radiusX, float radiusY) {
        this.ellipse(centreX, centreY, radiusX, radiusY, 0.0f, this.defaultLineWidth);
    }

    public void ellipse(float centreX, float centreY, float radiusX, float radiusY, float rotation) {
        this.ellipse(centreX, centreY, radiusX, radiusY, rotation, this.defaultLineWidth);
    }

    public void ellipse(float centreX, float centreY, float radiusX, float radiusY, float rotation, float lineWidth) {
        this.ellipse(centreX, centreY, radiusX, radiusY, rotation, lineWidth, this.isJoinNecessary(lineWidth) ? JoinType.SMOOTH : JoinType.NONE);
    }

    public void ellipse(float centreX, float centreY, float radiusX, float radiusY, float rotation, float lineWidth, JoinType joinType) {
        float circumference = (float)(6.2831854820251465 * Math.sqrt((radiusX * radiusX + radiusY * radiusY) / 2.0f));
        int sides = (int)(circumference / (24.0f * this.pixelSize));
        float a = Math.min(radiusX, radiusY);
        float b = Math.max(radiusX, radiusY);
        float eccentricity = (float)Math.sqrt(1.0f - a * a / (b * b));
        sides = (int)((float)sides + (float)sides * eccentricity / 16.0f);
        this.polygon(centreX, centreY, sides, radiusX, radiusY, rotation, lineWidth, joinType);
    }

    public void polygon(float centreX, float centreY, int sides, float scale) {
        this.polygon(centreX, centreY, sides, scale, scale, 0.0f, this.defaultLineWidth);
    }

    public void polygon(float centreX, float centreY, int sides, float radius, float rotation) {
        this.polygon(centreX, centreY, sides, radius, radius, rotation, this.defaultLineWidth);
    }

    public void polygon(float centreX, float centreY, int sides, float scaleX, float scaleY, float rotation) {
        this.polygon(centreX, centreY, sides, scaleX, scaleY, rotation, this.defaultLineWidth, this.isJoinNecessary(this.defaultLineWidth) ? JoinType.POINTY : JoinType.NONE);
    }

    public void polygon(float centreX, float centreY, int sides, float scaleX, float scaleY, float rotation, float lineWidth) {
        this.polygon(centreX, centreY, sides, scaleX, scaleY, rotation, lineWidth, this.isJoinNecessary(lineWidth) ? JoinType.POINTY : JoinType.NONE);
    }

    public void polygon(float centreX, float centreY, int sides, float scaleX, float scaleY, float rotation, JoinType joinType) {
        this.polygon(centreX, centreY, sides, scaleX, scaleY, rotation, this.defaultLineWidth, joinType);
    }

    public void polygon(float centreX, float centreY, int sides, float scaleX, float scaleY, float rotation, float lineWidth, JoinType joinType) {
        this.polygonDrawer.polygon(centreX, centreY, sides, scaleX, scaleY, rotation, lineWidth, joinType);
    }

    public void polygon(Polygon polygon) {
        this.polygon(polygon, this.defaultLineWidth, this.isJoinNecessary(this.defaultLineWidth) ? JoinType.POINTY : JoinType.NONE);
    }

    public void polygon(Polygon polygon, float lineWidth) {
        this.polygon(polygon, lineWidth, this.isJoinNecessary(this.defaultLineWidth) ? JoinType.POINTY : JoinType.NONE);
    }

    public void polygon(Polygon polygon, JoinType joinType) {
        this.polygon(polygon, this.defaultLineWidth, joinType);
    }

    public void polygon(Polygon polygon, float lineWidth, JoinType joinType) {
        float[] vxs = polygon.getTransformedVertices();
        this.pathDrawer.path(vxs, 0, vxs.length, lineWidth, joinType, false);
    }

    public void rectangle(Rectangle rect) {
        this.rectangle(rect, this.defaultLineWidth);
    }

    public void rectangle(Rectangle rect, Color color) {
        this.rectangle(rect, color, this.defaultLineWidth);
    }

    public void rectangle(Rectangle rect, float lineWidth) {
        this.rectangle(rect.x, rect.y, rect.width, rect.height, lineWidth);
    }

    public void rectangle(Rectangle rect, Color color, float lineWidth) {
        this.rectangle(rect.x, rect.y, rect.width, rect.height, color, lineWidth);
    }

    public void rectangle(float x, float y, float width, float height) {
        this.rectangle(x, y, width, height, this.defaultLineWidth);
    }

    public void rectangle(float x, float y, float width, float height, Color color) {
        this.rectangle(x, y, width, height, color, this.defaultLineWidth);
    }

    public void rectangle(float x, float y, float width, float height, float lineWidth) {
        this.rectangle(x, y, width, height, lineWidth, JoinType.POINTY);
    }

    public void rectangle(float x, float y, float width, float height, Color color, float lineWidth) {
        float oldColor = this.setColor(color);
        this.rectangle(x, y, width, height, lineWidth);
        this.setColor(oldColor);
    }

    public void rectangle(float x, float y, float width, float height, float lineWidth, JoinType joinType) {
        this.rectangle(x, y, width, height, lineWidth, 0.0f, joinType);
    }

    public void rectangle(float x, float y, float width, float height, float lineWidth, float rotation, JoinType joinType) {
        if (joinType == JoinType.POINTY && rotation == 0.0f) {
            float halfWidth = 0.5f * lineWidth;
            float X = x + width;
            float Y = y + height;
            this.lineDrawer.line(x + halfWidth, y, X - halfWidth, y, lineWidth, false);
            this.lineDrawer.line(x + halfWidth, Y, X - halfWidth, Y, lineWidth, false);
            this.lineDrawer.line(x, y - halfWidth, x, Y + halfWidth, lineWidth, false);
            this.lineDrawer.line(X, y - halfWidth, X, Y + halfWidth, lineWidth, false);
        } else {
            this.polygon(x + 0.5f * width, y + 0.5f * height, 4, lineWidth, rotation + 0.7853982f, width, height, joinType);
        }
    }
}

