/*
 * Decompiled with CFR 0.152.
 */
package space.earlygrey.shapedrawer;

import com.badlogic.gdx.math.Vector2;
import space.earlygrey.shapedrawer.DrawerTemplate;
import space.earlygrey.shapedrawer.JoinType;
import space.earlygrey.shapedrawer.Joiner;
import space.earlygrey.shapedrawer.ShapeDrawer;

class PolygonDrawer
extends DrawerTemplate {
    static final Vector2 centre = new Vector2();

    PolygonDrawer(ShapeDrawer drawer) {
        super(drawer);
    }

    void polygon(float centreX, float centreY, int sides, float radiusX, float radiusY, float rotation, float lineWidth, JoinType joinType) {
        float angleInterval = (float)Math.PI * 2 / (float)sides;
        float halfLineWidth = 0.5f * lineWidth;
        centre.set(centreX, centreY);
        dir.set(1.0f, 0.0f);
        C.set(radiusX, 0.0f);
        switch (joinType) {
            case NONE: {
                this.drawPolygonNoJoin(centre, sides, lineWidth, rotation, angleInterval, radiusX, radiusY);
                break;
            }
            case SMOOTH: {
                this.drawPolygonSmoothJoin(centre, sides, halfLineWidth, rotation, angleInterval, radiusX, radiusY);
                break;
            }
            default: {
                this.drawPolygonPointyJoin(centre, sides, halfLineWidth, rotation, angleInterval, radiusX, radiusY);
            }
        }
    }

    void drawPolygonNoJoin(Vector2 centre, int sides, float lineWidth, float rotation, float angleInterval, float radiusX, float radiusY) {
        int n = sides;
        float cos = (float)Math.cos(angleInterval);
        float sin = (float)Math.sin(angleInterval);
        float cosRot = (float)Math.cos(rotation);
        float sinRot = (float)Math.sin(rotation);
        for (int i = 0; i < n; ++i) {
            A.set(B);
            B.set(C);
            dir.set(PolygonDrawer.dir.x * cos - PolygonDrawer.dir.y * sin, PolygonDrawer.dir.x * sin + PolygonDrawer.dir.y * cos);
            C.set(dir).scl(radiusX, radiusY);
            float x1 = PolygonDrawer.B.x * cosRot - PolygonDrawer.B.y * sinRot + centre.x;
            float y1 = PolygonDrawer.B.x * sinRot + PolygonDrawer.B.y * cosRot + centre.y;
            float x2 = PolygonDrawer.C.x * cosRot - PolygonDrawer.C.y * sinRot + centre.x;
            float y2 = PolygonDrawer.C.x * sinRot + PolygonDrawer.C.y * cosRot + centre.y;
            this.drawer.line(x1, y1, x2, y2, lineWidth);
        }
    }

    void drawPolygonPointyJoin(Vector2 centre, int sides, float halfLineWidth, float rotation, float angleInterval, float radiusX, float radiusY) {
        int n = sides;
        float cos = (float)Math.cos(angleInterval);
        float sin = (float)Math.sin(angleInterval);
        float cosRot = (float)Math.cos(rotation);
        float sinRot = (float)Math.sin(rotation);
        for (int i = -2; i < n; ++i) {
            A.set(B);
            B.set(C);
            dir.set(PolygonDrawer.dir.x * cos - PolygonDrawer.dir.y * sin, PolygonDrawer.dir.x * sin + PolygonDrawer.dir.y * cos);
            C.set(dir).scl(radiusX, radiusY);
            if (i >= 0) {
                this.vert1(PolygonDrawer.E.x * cosRot - PolygonDrawer.E.y * sinRot + centre.x, PolygonDrawer.E.x * sinRot + PolygonDrawer.E.y * cosRot + centre.y);
                this.vert2(PolygonDrawer.D.x * cosRot - PolygonDrawer.D.y * sinRot + centre.x, PolygonDrawer.D.x * sinRot + PolygonDrawer.D.y * cosRot + centre.y);
                Joiner.preparePointyJoin(A, B, C, D, E, halfLineWidth);
                this.vert3(PolygonDrawer.D.x * cosRot - PolygonDrawer.D.y * sinRot + centre.x, PolygonDrawer.D.x * sinRot + PolygonDrawer.D.y * cosRot + centre.y);
                this.vert4(PolygonDrawer.E.x * cosRot - PolygonDrawer.E.y * sinRot + centre.x, PolygonDrawer.E.x * sinRot + PolygonDrawer.E.y * cosRot + centre.y);
                this.drawVerts();
                continue;
            }
            if (i != -1) continue;
            Joiner.preparePointyJoin(A, B, C, D, E, halfLineWidth);
        }
    }

    void drawPolygonSmoothJoin(Vector2 centre, int sides, float halfLineWidth, float rotation, float angleInterval, float radiusX, float radiusY) {
        int n = sides;
        float cos = (float)Math.cos(angleInterval);
        float sin = (float)Math.sin(angleInterval);
        float cosRot = (float)Math.cos(rotation);
        float sinRot = (float)Math.sin(rotation);
        for (int i = -2; i < n; ++i) {
            if (i >= 0) {
                Joiner.prepareSmoothJoin(A, B, C, D, E, halfLineWidth, true);
                this.vert1(PolygonDrawer.E.x * cosRot - PolygonDrawer.E.y * sinRot + centre.x, PolygonDrawer.E.x * sinRot + PolygonDrawer.E.y * cosRot + centre.y);
                this.vert2(PolygonDrawer.D.x * cosRot - PolygonDrawer.D.y * sinRot + centre.x, PolygonDrawer.D.x * sinRot + PolygonDrawer.D.y * cosRot + centre.y);
            }
            A.set(B);
            B.set(C);
            dir.set(PolygonDrawer.dir.x * cos - PolygonDrawer.dir.y * sin, PolygonDrawer.dir.x * sin + PolygonDrawer.dir.y * cos);
            C.set(dir).scl(radiusX, radiusY);
            if (i < 0) continue;
            Joiner.prepareSmoothJoin(A, B, C, D, E, halfLineWidth, false);
            this.vert3(PolygonDrawer.D.x * cosRot - PolygonDrawer.D.y * sinRot + centre.x, PolygonDrawer.D.x * sinRot + PolygonDrawer.D.y * cosRot + centre.y);
            this.vert4(PolygonDrawer.E.x * cosRot - PolygonDrawer.E.y * sinRot + centre.x, PolygonDrawer.E.x * sinRot + PolygonDrawer.E.y * cosRot + centre.y);
            this.drawVerts();
            this.drawSmoothJoinFill(A, B, C, D, E, centre, cosRot, sinRot, halfLineWidth);
        }
    }
}

