/*
 * Decompiled with CFR 0.152.
 */
package space.earlygrey.shapedrawer;

import space.earlygrey.shapedrawer.DrawerTemplate;
import space.earlygrey.shapedrawer.ShapeDrawer;
import space.earlygrey.shapedrawer.ShapeUtils;

class LineDrawer
extends DrawerTemplate {
    LineDrawer(ShapeDrawer drawer) {
        super(drawer);
    }

    void line(float x1, float y1, float x2, float y2, float lineWidth, boolean snap) {
        float xdif = 0.0f;
        float ydif = 0.0f;
        float lx = x2 - x1;
        float ly = y2 - y1;
        if (snap) {
            float offset = this.drawer.offset;
            float pixelSize = this.drawer.pixelSize;
            float halfPixelSize = this.drawer.halfPixelSize;
            x1 = ShapeUtils.snap(x1, pixelSize, halfPixelSize) - Math.signum(lx) * offset;
            y1 = ShapeUtils.snap(y1, pixelSize, halfPixelSize) - Math.signum(ly) * offset;
            x2 = ShapeUtils.snap(x2, pixelSize, halfPixelSize) + Math.signum(lx) * offset;
            y2 = ShapeUtils.snap(y2, pixelSize, halfPixelSize) + Math.signum(ly) * offset;
        }
        float halfLineWidth = 0.5f * lineWidth;
        if (x1 == x2) {
            xdif = halfLineWidth;
        } else if (y1 == y2) {
            ydif = halfLineWidth;
        } else {
            xdif = y2 - y1;
            ydif = x2 - x1;
            float l2 = xdif * xdif + ydif * ydif;
            float invl = 1.0f / (float)Math.sqrt(l2);
            float s = invl * halfLineWidth;
            xdif *= s;
            ydif *= s;
        }
        this.x1(x1 + xdif);
        this.y1(y1 - ydif);
        this.x2(x1 - xdif);
        this.y2(y1 + ydif);
        this.x3(x2 - xdif);
        this.y3(y2 + ydif);
        this.x4(x2 + xdif);
        this.y4(y2 - ydif);
        this.drawVerts();
    }
}

