/*
 * Decompiled with CFR 0.152.
 */
package space.earlygrey.shapedrawer;

import com.badlogic.gdx.math.Vector;
import com.badlogic.gdx.math.Vector2;
import space.earlygrey.shapedrawer.ShapeUtils;

class Joiner {
    static final Vector2 AB = new Vector2();
    static final Vector2 BC = new Vector2();
    static final Vector2 v = new Vector2();

    Joiner() {
    }

    static float preparePointyJoin(Vector2 A, Vector2 B, Vector2 C, Vector2 D, Vector2 E, float halfLineWidth) {
        AB.set(B).sub(A);
        BC.set(C).sub(B);
        float angle = AB.angleRad(BC);
        if (ShapeUtils.epsilonEquals(angle, 0.0f) || ShapeUtils.epsilonEquals(angle, (float)Math.PI * 2)) {
            Joiner.prepareStraightJoin(B, D, E, halfLineWidth);
            return angle;
        }
        float len = (float)((double)halfLineWidth / Math.sin(angle));
        boolean bendsLeft = angle > 0.0f;
        AB.setLength(len);
        BC.setLength(len);
        Vector2 insidePoint = bendsLeft ? D : E;
        Vector2 outsidePoint = bendsLeft ? E : D;
        insidePoint.set((Vector)B).sub((Vector)AB).add((Vector)BC);
        outsidePoint.set((Vector)B).add((Vector)AB).sub((Vector)BC);
        return angle;
    }

    static boolean prepareSmoothJoin(Vector2 A, Vector2 B, Vector2 C, Vector2 D, Vector2 E, float halfLineWidth, boolean startOfEdge) {
        Vector2 edgeDirection;
        AB.set(B).sub(A);
        BC.set(C).sub(B);
        float angle = AB.angleRad(BC);
        if (ShapeUtils.epsilonEquals(angle, 0.0f) || ShapeUtils.epsilonEquals(angle, (float)Math.PI * 2)) {
            Joiner.prepareStraightJoin(B, D, E, halfLineWidth);
            return true;
        }
        float len = (float)((double)halfLineWidth / Math.sin(angle));
        AB.setLength(len);
        BC.setLength(len);
        boolean bendsLeft = angle > 0.0f;
        Vector2 insidePoint = bendsLeft ? D : E;
        Vector2 outsidePoint = bendsLeft ? E : D;
        insidePoint.set((Vector)B).sub((Vector)AB).add((Vector)BC);
        Vector2 vector2 = edgeDirection = startOfEdge ? BC : AB;
        if (bendsLeft) {
            v.set(edgeDirection.y, -edgeDirection.x);
        } else {
            v.set(-edgeDirection.y, edgeDirection.x);
        }
        v.setLength(halfLineWidth);
        outsidePoint.set((Vector)B).add((Vector)v);
        return bendsLeft;
    }

    static void prepareStraightJoin(Vector2 B, Vector2 D, Vector2 E, float halfLineWidth) {
        AB.setLength(halfLineWidth);
        D.set(-Joiner.AB.y, Joiner.AB.x).add(B);
        E.set(Joiner.AB.y, -Joiner.AB.x).add(B);
    }
}

