/*
 * Decompiled with CFR 0.152.
 */
package space.earlygrey.shapedrawer;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector2;

public abstract class AbstractShapeDrawer {
    protected final Batch batch;
    protected TextureRegion r;
    protected final float[] verts = new float[20];
    protected float pixelSize = 1.0f;
    protected float halfPixelSize = 0.5f * this.pixelSize;
    protected float offset = 0.001f * this.pixelSize;
    protected float defaultLineWidth = this.pixelSize;
    protected boolean defaultSnap = false;
    protected static final Matrix4 mat4 = new Matrix4();

    protected AbstractShapeDrawer(Batch batch, TextureRegion region) {
        this.batch = batch;
        this.setTextureRegion(region);
        this.setColor(Color.WHITE);
    }

    public void update() {
        this.update(true);
    }

    public void update(boolean updatePixelSize) {
        if (updatePixelSize) {
            this.updatePixelSize();
        }
    }

    public float updatePixelSize() {
        Matrix4 trans = this.getBatch().getTransformMatrix();
        Matrix4 proj = this.getBatch().getProjectionMatrix();
        mat4.set(proj).mul(trans);
        float scaleX = mat4.getScaleX();
        float worldWidth = 2.0f / scaleX;
        float newPixelSize = worldWidth / (float)Gdx.graphics.getWidth();
        return this.setPixelSize(newPixelSize);
    }

    protected boolean isJoinNecessary(float lineWidth) {
        return lineWidth > 3.0f * this.pixelSize;
    }

    public float setPixelSize(float pixelSize) {
        float oldPixelSize = this.pixelSize;
        this.pixelSize = pixelSize;
        this.halfPixelSize = 0.5f * pixelSize;
        this.offset = 0.001f * pixelSize;
        return oldPixelSize;
    }

    public float getPixelSize() {
        return this.pixelSize;
    }

    public Batch getBatch() {
        return this.batch;
    }

    public TextureRegion getRegion() {
        return this.r;
    }

    public float getDefaultLineWidth() {
        return this.defaultLineWidth;
    }

    public float setDefaultLineWidth(float defaultLineWidth) {
        float oldWidth = this.defaultLineWidth;
        this.defaultLineWidth = defaultLineWidth;
        return oldWidth;
    }

    public boolean isDefaultSnap() {
        return this.defaultSnap;
    }

    public boolean setDefaultSnap(boolean defaultSnap) {
        boolean oldSnap = this.defaultSnap;
        this.defaultSnap = defaultSnap;
        return oldSnap;
    }

    public TextureRegion setTextureRegion(TextureRegion region) {
        TextureRegion oldRegion = this.r;
        this.r = region;
        this.verts[3] = this.r.getU();
        this.verts[4] = this.r.getV();
        this.verts[8] = this.r.getU2();
        this.verts[9] = this.r.getV();
        this.verts[13] = this.r.getU2();
        this.verts[14] = this.r.getV2();
        this.verts[18] = this.r.getU();
        this.verts[19] = this.r.getV2();
        return oldRegion;
    }

    public float setColor(Color color) {
        return this.setColor(color.toFloatBits());
    }

    public float setColor(float floatBits) {
        float oldColor = this.getPackedColor();
        this.verts[2] = floatBits;
        this.verts[7] = floatBits;
        this.verts[12] = floatBits;
        this.verts[17] = floatBits;
        return oldColor;
    }

    public float getPackedColor() {
        return this.verts[2];
    }

    protected void drawVerts() {
        this.batch.draw(this.r.getTexture(), this.verts, 0, 20);
    }

    protected void x1(float x1) {
        this.verts[0] = x1;
    }

    protected void y1(float y1) {
        this.verts[1] = y1;
    }

    protected void x2(float x2) {
        this.verts[5] = x2;
    }

    protected void y2(float y2) {
        this.verts[6] = y2;
    }

    protected void x3(float x3) {
        this.verts[10] = x3;
    }

    protected void y3(float y3) {
        this.verts[11] = y3;
    }

    protected void x4(float x4) {
        this.verts[15] = x4;
    }

    protected void y4(float y4) {
        this.verts[16] = y4;
    }

    protected void vert1(float x, float y) {
        this.x1(x);
        this.y1(y);
    }

    protected void vert2(float x, float y) {
        this.x2(x);
        this.y2(y);
    }

    protected void vert3(float x, float y) {
        this.x3(x);
        this.y3(y);
    }

    protected void vert4(float x, float y) {
        this.x4(x);
        this.y4(y);
    }

    protected void vert1(Vector2 V) {
        this.vert1(V.x, V.y);
    }

    protected void vert2(Vector2 V) {
        this.vert2(V.x, V.y);
    }

    protected void vert3(Vector2 V) {
        this.vert3(V.x, V.y);
    }

    protected void vert4(Vector2 V) {
        this.vert4(V.x, V.y);
    }

    protected void vert1(Vector2 V, Vector2 offset) {
        this.vert1(V.x + offset.x, V.y + offset.y);
    }

    protected void vert2(Vector2 V, Vector2 offset) {
        this.vert2(V.x + offset.x, V.y + offset.y);
    }

    protected void vert3(Vector2 V, Vector2 offset) {
        this.vert3(V.x + offset.x, V.y + offset.y);
    }

    protected void vert4(Vector2 V, Vector2 offset) {
        this.vert4(V.x + offset.x, V.y + offset.y);
    }

    protected float x1() {
        return this.verts[0];
    }

    protected float y1() {
        return this.verts[1];
    }

    protected float x2() {
        return this.verts[5];
    }

    protected float y2() {
        return this.verts[6];
    }

    protected float x3() {
        return this.verts[10];
    }

    protected float y3() {
        return this.verts[11];
    }

    protected float x4() {
        return this.verts[15];
    }

    protected float y4() {
        return this.verts[16];
    }
}

