/*
 * Decompiled with CFR 0.152.
 */
package space.arim.dazzleconf.internal.processor;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import space.arim.dazzleconf.AuxiliaryKeys;
import space.arim.dazzleconf.ConfigurationOptions;
import space.arim.dazzleconf.error.BadValueException;
import space.arim.dazzleconf.error.IllDefinedConfigException;
import space.arim.dazzleconf.error.InvalidConfigException;
import space.arim.dazzleconf.error.MissingKeyException;
import space.arim.dazzleconf.error.MissingValueException;
import space.arim.dazzleconf.internal.ConfEntry;
import space.arim.dazzleconf.internal.ConfigurationDefinition;
import space.arim.dazzleconf.internal.processor.Composition;
import space.arim.dazzleconf.internal.processor.ConfigInvocationHandler;
import space.arim.dazzleconf.internal.processor.DefaultMethodConfigInvocationHandler;
import space.arim.dazzleconf.internal.processor.FlexibleTypeImpl;
import space.arim.dazzleconf.internal.type.ReturnTypeWithConfigDefinition;
import space.arim.dazzleconf.internal.type.SimpleSubSectionReturnType;
import space.arim.dazzleconf.internal.util.ConfigurationInvoker;
import space.arim.dazzleconf.validator.ValueValidator;

public abstract class ProcessorBase<C> {
    private final ConfigurationOptions options;
    private final ConfigurationDefinition<C> definition;
    private final ConfigurationInvoker<C> auxiliaryValues;
    private final Map<String, Object> result = new HashMap<String, Object>();
    private boolean usedAuxiliary;

    ProcessorBase(ConfigurationOptions options, ConfigurationDefinition<C> definition, C auxiliaryValues) {
        this.options = options;
        this.definition = definition;
        this.auxiliaryValues = auxiliaryValues == null ? null : new ConfigurationInvoker<C>(auxiliaryValues);
    }

    public C createConfig() throws InvalidConfigException {
        Object proxy;
        this.process();
        Class<C> configClass = this.definition.getConfigClass();
        Class[] intf = this.usedAuxiliary ? new Class[]{configClass, AuxiliaryKeys.class} : new Class[]{configClass};
        ClassLoader classLoader = configClass.getClassLoader();
        if (this.definition.hasDefaultMethods()) {
            DefaultMethodConfigInvocationHandler handler = new DefaultMethodConfigInvocationHandler(this.result);
            proxy = Proxy.newProxyInstance(classLoader, intf, (InvocationHandler)handler);
            handler.initDefaultMethods(proxy, this.definition.getDefaultMethods());
        } else {
            proxy = Proxy.newProxyInstance(classLoader, intf, (InvocationHandler)new ConfigInvocationHandler(this.result));
        }
        return configClass.cast(proxy);
    }

    private void process() throws InvalidConfigException {
        for (ConfEntry entry : this.definition.getEntries()) {
            Object formerValue;
            Object value;
            String methodName = entry.getMethod().getName();
            try {
                value = this.getProcessedValue(entry, this.getPreValue(entry));
            }
            catch (MissingKeyException mke) {
                if (this.auxiliaryValues == null) {
                    throw mke;
                }
                value = this.getAuxiliaryValue(entry);
                this.usedAuxiliary = true;
            }
            if ((formerValue = this.result.put(methodName, value)) == null) continue;
            throw new IllDefinedConfigException("Duplicate method name " + methodName);
        }
    }

    private Object getPreValue(ConfEntry entry) throws InvalidConfigException {
        Object preValue = this.getValueFromSources(entry);
        String key = entry.getKey();
        if (preValue == null) {
            throw MissingValueException.forKey(key);
        }
        return preValue;
    }

    private Object getProcessedValue(ConfEntry entry, Object preValue) throws InvalidConfigException {
        String key = entry.getKey();
        FlexibleTypeImpl flexibleType = new FlexibleTypeImpl(key, preValue, this.options, this.definition.getSerialisers());
        Composition composition = new Composition(this, entry, preValue, flexibleType);
        Object value = composition.processObject();
        this.validate(entry, value);
        return value;
    }

    private void validate(ConfEntry entry, Object value) throws BadValueException {
        if (entry.returnType() instanceof SimpleSubSectionReturnType) {
            return;
        }
        String key = entry.getKey();
        ValueValidator validator = entry.getValidator().orElseGet(() -> this.options.getValidators().get(key));
        if (validator != null) {
            validator.validate(key, value);
        }
    }

    private Object getAuxiliaryValue(ConfEntry entry) {
        return this.auxiliaryValues.getEntryValue(entry);
    }

    <N> N createNested(ConfEntry nestedEntry, ReturnTypeWithConfigDefinition<N, ?> returnType, Object preValue) throws InvalidConfigException {
        ConfigurationDefinition<N> nestedDefinition = returnType.configDefinition();
        N nestedAuxiliary = null;
        if (this.auxiliaryValues != null && returnType instanceof SimpleSubSectionReturnType) {
            Object auxiliaryValue = this.getAuxiliaryValue(nestedEntry);
            nestedAuxiliary = nestedDefinition.getConfigClass().cast(auxiliaryValue);
        }
        return this.createChildConfig(this.options, nestedDefinition, nestedEntry.getKey(), preValue, nestedAuxiliary);
    }

    <N> N createFromProcessor(ProcessorBase<N> childProcessor) throws InvalidConfigException {
        N childConfig = childProcessor.createConfig();
        if (childProcessor.usedAuxiliary) {
            this.usedAuxiliary = true;
        }
        return childConfig;
    }

    abstract <N> N createChildConfig(ConfigurationOptions var1, ConfigurationDefinition<N> var2, String var3, Object var4, N var5) throws InvalidConfigException;

    abstract Object getValueFromSources(ConfEntry var1) throws InvalidConfigException;
}

