/*
 * Decompiled with CFR 0.152.
 */
package space.arim.dazzleconf.internal.processor;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import space.arim.dazzleconf.ConfigurationOptions;
import space.arim.dazzleconf.annote.ConfDefault;
import space.arim.dazzleconf.error.IllDefinedConfigException;
import space.arim.dazzleconf.error.InvalidConfigException;
import space.arim.dazzleconf.internal.ConfEntry;
import space.arim.dazzleconf.internal.ConfigurationDefinition;
import space.arim.dazzleconf.internal.processor.DefaultObjectHelper;
import space.arim.dazzleconf.internal.processor.ProcessorBase;
import space.arim.dazzleconf.internal.type.ReturnType;
import space.arim.dazzleconf.internal.type.SimpleSubSectionReturnType;
import space.arim.dazzleconf.internal.util.ImmutableCollections;

public class DefaultsProcessor<C>
extends ProcessorBase<C> {
    static final Object CREATE_DEFAULT_SECTION = new Object();

    public DefaultsProcessor(ConfigurationOptions options, ConfigurationDefinition<C> definition) {
        super(options, definition, null);
    }

    @Override
    <N> N createChildConfig(ConfigurationOptions options, ConfigurationDefinition<N> childDefinition, String key, Object preValue, N nestedAuxiliaryValues) throws InvalidConfigException {
        if (nestedAuxiliaryValues != null) {
            throw new AssertionError((Object)"Internal error: DefaultsProcessor does not handle auxiliary entries");
        }
        if (preValue == CREATE_DEFAULT_SECTION) {
            return this.createFromProcessor(new DefaultsProcessor<N>(options, childDefinition));
        }
        Class<N> configClass = childDefinition.getConfigClass();
        if (!configClass.isInstance(preValue)) {
            throw new IllDefinedConfigException("Default value at " + key + " must be an instance of " + configClass);
        }
        return configClass.cast(preValue);
    }

    @Override
    Object getValueFromSources(ConfEntry entry) throws InvalidConfigException {
        ReturnType<?> returnType = entry.returnType();
        if (returnType instanceof SimpleSubSectionReturnType) {
            return CREATE_DEFAULT_SECTION;
        }
        Method method = entry.getMethod();
        ConfDefault.DefaultBoolean ofBoolean = method.getAnnotation(ConfDefault.DefaultBoolean.class);
        if (ofBoolean != null) {
            return ofBoolean.value();
        }
        ConfDefault.DefaultBooleans ofBooleans = method.getAnnotation(ConfDefault.DefaultBooleans.class);
        if (ofBooleans != null) {
            return DefaultsProcessor.toList(ofBooleans.value());
        }
        ConfDefault.DefaultInteger ofInteger = method.getAnnotation(ConfDefault.DefaultInteger.class);
        if (ofInteger != null) {
            return ofInteger.value();
        }
        ConfDefault.DefaultIntegers ofIntegers = method.getAnnotation(ConfDefault.DefaultIntegers.class);
        if (ofIntegers != null) {
            return DefaultsProcessor.toList(ofIntegers.value());
        }
        ConfDefault.DefaultLong ofLong = method.getAnnotation(ConfDefault.DefaultLong.class);
        if (ofLong != null) {
            return ofLong.value();
        }
        ConfDefault.DefaultLongs ofLongs = method.getAnnotation(ConfDefault.DefaultLongs.class);
        if (ofLongs != null) {
            return DefaultsProcessor.toList(ofLongs.value());
        }
        ConfDefault.DefaultDouble ofDouble = method.getAnnotation(ConfDefault.DefaultDouble.class);
        if (ofDouble != null) {
            return ofDouble.value();
        }
        ConfDefault.DefaultDoubles ofDoubles = method.getAnnotation(ConfDefault.DefaultDoubles.class);
        if (ofDoubles != null) {
            return DefaultsProcessor.toList(ofDoubles.value());
        }
        ConfDefault.DefaultString ofString = method.getAnnotation(ConfDefault.DefaultString.class);
        if (ofString != null) {
            return ofString.value();
        }
        ConfDefault.DefaultStrings ofStrings = method.getAnnotation(ConfDefault.DefaultStrings.class);
        if (ofStrings != null) {
            return ImmutableCollections.listOf(ofStrings.value());
        }
        DefaultObjectHelper helper = new DefaultObjectHelper(entry, this);
        ConfDefault.DefaultMap ofMap = method.getAnnotation(ConfDefault.DefaultMap.class);
        if (ofMap != null) {
            return helper.toMap(ofMap.value());
        }
        ConfDefault.DefaultObject ofMethod = method.getAnnotation(ConfDefault.DefaultObject.class);
        if (ofMethod != null) {
            return helper.toObject(ofMethod.value());
        }
        throw helper.badDefault("No default value annotation present");
    }

    private static List<Boolean> toList(boolean[] booleanArray) {
        ArrayList<Boolean> booleans = new ArrayList<Boolean>(booleanArray.length);
        for (boolean b : booleanArray) {
            booleans.add(b);
        }
        return booleans;
    }

    private static List<Integer> toList(int[] integerArray) {
        ArrayList<Integer> integers = new ArrayList<Integer>(integerArray.length);
        for (int i : integerArray) {
            integers.add(i);
        }
        return integers;
    }

    private static List<Long> toList(long[] longArray) {
        ArrayList<Long> longs = new ArrayList<Long>(longArray.length);
        for (long l : longArray) {
            longs.add(l);
        }
        return longs;
    }

    private static List<Double> toList(double[] doubleArray) {
        ArrayList<Double> doubles = new ArrayList<Double>(doubleArray.length);
        for (double d : doubleArray) {
            doubles.add(d);
        }
        return doubles;
    }
}

