/*
 * Decompiled with CFR 0.152.
 */
package space.arim.dazzleconf.internal.error;

import java.util.Locale;

public final class Errors {
    private Errors() {
    }

    static CharSequence pad(char prefix, int digits, int errorCode) {
        String codeString = Integer.toHexString(errorCode).toUpperCase(Locale.ROOT);
        int padAmount = digits - codeString.length();
        StringBuilder builder = new StringBuilder();
        builder.append(prefix);
        for (int n = 0; n < padAmount; ++n) {
            builder.append('0');
        }
        builder.append(codeString);
        return builder;
    }

    public static interface StandardError {
        public When when();

        public CharSequence errorCodeDisplay();

        public String message();

        default public String fullMessage(String extraInfo) {
            String extra = extraInfo.isEmpty() ? "None" : extraInfo;
            return "Encountered an error while " + (Object)((Object)this.when()) + ". \nError code: " + this.errorCodeDisplay() + ". " + this.message() + "\n\nConsult the error codes: https://github.com/A248/DazzleConf/wiki/Error-Messages \nExtra info: " + extra;
        }
    }

    static enum When {
        LOAD_CONFIG("loading the configuration"),
        WRITE_CONFIG("writing or creating the configuration");

        private final String display;

        private When(String display) {
            this.display = display;
        }

        public String toString() {
            return this.display;
        }
    }
}

