/*
 * Decompiled with CFR 0.152.
 */
package space.arim.dazzleconf.internal.error;

import space.arim.dazzleconf.error.IllDefinedConfigException;
import space.arim.dazzleconf.internal.error.Errors;

public enum DeveloperError implements Errors.StandardError
{
    EXPECTED_MAP_WHILE_WRITE(26, Errors.When.WRITE_CONFIG, "Expected a configuration section inside the data, but a simple object was present."),
    REPLACED_OBJECT(27, Errors.When.WRITE_CONFIG, "Replaced a configuration object with another one."),
    EXPECTED_MAP_WHILE_LOAD(28, Errors.When.LOAD_CONFIG, "Expected a configuration section inside the data, but a simple object was present.");

    private final int errorCode;
    private final Errors.When when;
    private final String message;

    private DeveloperError(int errorCode, Errors.When when, String message) {
        this.errorCode = errorCode;
        this.when = when;
        this.message = message;
    }

    @Override
    public Errors.When when() {
        return this.when;
    }

    @Override
    public CharSequence errorCodeDisplay() {
        return Errors.pad('D', 2, this.errorCode);
    }

    @Override
    public String message() {
        return this.message;
    }

    public IllDefinedConfigException toIllDefinedConfigException(String extraInfo) {
        return new IllDefinedConfigException(this.fullMessage(extraInfo));
    }
}

