/*
 * Decompiled with CFR 0.152.
 */
package space.arim.dazzleconf.internal;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import space.arim.dazzleconf.error.MissingKeyException;
import space.arim.dazzleconf.factory.CommentedWrapper;
import space.arim.dazzleconf.internal.error.DeveloperError;

public class NestedMapHelper {
    private final Map<String, Object> topLevelMap;
    private static final Pattern PERIOD_PATTERN = Pattern.compile(".", 16);

    public NestedMapHelper(Map<String, Object> topLevelMap) {
        this.topLevelMap = Objects.requireNonNull(topLevelMap, "topLevelMap");
    }

    public Map<String, Object> getTopLevelMap() {
        return this.topLevelMap;
    }

    public void put(String key, Object value) {
        this.put0(key, value, false);
    }

    public void combine(String key, Object object) {
        this.put0(key, object, true);
    }

    private void put0(String key, Object value, boolean combine) {
        String[] keyParts = PERIOD_PATTERN.split(key);
        Map<String, Object> currentMap = this.topLevelMap;
        int lastIndex = keyParts.length - 1;
        for (int n = 0; n < lastIndex; ++n) {
            currentMap = NestedMapHelper.computeMapOrFail(key, currentMap, keyParts[n]);
        }
        if (combine) {
            Map combineWith;
            LinkedHashMap toCombine;
            LinkedHashMap toCombineOriginal = NestedMapHelper.computeMapOrFail(key, currentMap, keyParts[lastIndex]);
            LinkedHashMap linkedHashMap = toCombine = toCombineOriginal instanceof LinkedHashMap ? toCombineOriginal : new LinkedHashMap(toCombineOriginal);
            if (value instanceof CommentedWrapper) {
                CommentedWrapper commentWrapper = (CommentedWrapper)value;
                currentMap.put(keyParts[lastIndex], new CommentedWrapper(commentWrapper.getComments(), toCombine));
                combineWith = (Map)commentWrapper.getValue();
            } else {
                currentMap.put(keyParts[lastIndex], toCombine);
                combineWith = (Map)value;
            }
            toCombine.putAll(combineWith);
        } else {
            Object previous = currentMap.put(keyParts[lastIndex], value);
            if (previous != null) {
                throw DeveloperError.REPLACED_OBJECT.toIllDefinedConfigException("Replaced object " + previous + " at " + key + " with " + value);
            }
        }
    }

    private static Map<String, Object> computeMapOrFail(String fullKey, Map<String, Object> currentMap, String keyPart) {
        Object shouldBeMap = currentMap.computeIfAbsent(keyPart, k -> new LinkedHashMap());
        if (shouldBeMap instanceof CommentedWrapper) {
            shouldBeMap = ((CommentedWrapper)shouldBeMap).getValue();
        }
        if (!(shouldBeMap instanceof Map)) {
            throw DeveloperError.EXPECTED_MAP_WHILE_WRITE.toIllDefinedConfigException("Value " + shouldBeMap + " along the path of " + fullKey + " is not a Map");
        }
        return (Map)shouldBeMap;
    }

    public Object get(String key) throws MissingKeyException {
        Map currentMap = this.topLevelMap;
        String[] keyParts = PERIOD_PATTERN.split(key);
        int lastIndex = keyParts.length - 1;
        for (int n = 0; n < lastIndex; ++n) {
            String keyPart = keyParts[n];
            Object nextMap = currentMap.get(keyPart);
            if (nextMap == null) {
                throw MissingKeyException.forKey(key);
            }
            if (!(nextMap instanceof Map)) {
                throw DeveloperError.EXPECTED_MAP_WHILE_LOAD.toIllDefinedConfigException("At key " + key);
            }
            currentMap = (Map)nextMap;
        }
        Object value = currentMap.get(keyParts[lastIndex]);
        if (value == null) {
            throw MissingKeyException.forKey(key);
        }
        return value;
    }
}

