/*
 * Decompiled with CFR 0.152.
 */
package space.arim.dazzleconf.internal.util;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import space.arim.dazzleconf.error.IllDefinedConfigException;

public final class MethodUtil {
    private static final DefaultMethodProvider DEFAULT_METHOD_PROVIDER = MethodUtil.createDefaultMethodProvider();

    private MethodUtil() {
    }

    public static String getQualifiedName(Method method) {
        return method.getDeclaringClass().getName() + "#" + method.getName();
    }

    public static boolean isDefault(Method method) {
        boolean isDefault;
        int modifiers = method.getModifiers();
        boolean bl = isDefault = (modifiers & 0x409) == 1;
        assert (isDefault == method.isDefault());
        return isDefault;
    }

    public static MethodHandle createDefaultMethodHandle(Method method) {
        try {
            return DEFAULT_METHOD_PROVIDER.getMethodHandle(method);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException ex) {
            throw new IllDefinedConfigException("Unable to generate default method accessor for " + MethodUtil.getQualifiedName(method), ex);
        }
    }

    private static DefaultMethodProvider createDefaultMethodProvider() {
        try {
            MethodHandles.class.getDeclaredMethod("privateLookupIn", Class.class, MethodHandles.Lookup.class);
            return new Java11DefaultMethodProvider();
        }
        catch (NoSuchMethodException nsme) {
            return new Java8DefaultMethodProvider();
        }
    }

    static interface DefaultMethodProvider {
        public MethodHandle getMethodHandle(Method var1) throws IllegalAccessException, InstantiationException, InvocationTargetException;
    }

    private static class Java11DefaultMethodProvider
    implements DefaultMethodProvider {
        private Java11DefaultMethodProvider() {
        }

        @Override
        public MethodHandle getMethodHandle(Method method) throws IllegalAccessException {
            Class<?> declaringClass = method.getDeclaringClass();
            MethodUtil.class.getModule().addReads(declaringClass.getModule());
            return MethodHandles.privateLookupIn(declaringClass, MethodHandles.lookup()).unreflectSpecial(method, declaringClass);
        }
    }

    private static class Java8DefaultMethodProvider
    implements DefaultMethodProvider {
        private static final Constructor<MethodHandles.Lookup> lookupConstructor;

        private Java8DefaultMethodProvider() {
        }

        @Override
        public MethodHandle getMethodHandle(Method method) throws IllegalAccessException, InvocationTargetException, InstantiationException {
            Class<?> declaringClass = method.getDeclaringClass();
            return lookupConstructor.newInstance(declaringClass).unreflectSpecial(method, declaringClass);
        }

        static {
            try {
                lookupConstructor = MethodHandles.Lookup.class.getDeclaredConstructor(Class.class);
                lookupConstructor.setAccessible(true);
            }
            catch (NoSuchMethodException | SecurityException ex) {
                throw new ExceptionInInitializerError(ex);
            }
        }
    }
}

