/*
 * Decompiled with CFR 0.152.
 */
package space.arim.dazzleconf.internal.type;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import space.arim.dazzleconf.internal.type.TypeInfo;

public enum CollectionKind {
    COLLECTION,
    SET,
    LIST;


    public static boolean isCollectionOrSubclass(TypeInfo<?> typeInfo) {
        Class<?> rawType = typeInfo.rawType();
        return rawType.equals(Collection.class) || rawType.equals(Set.class) || rawType.equals(List.class);
    }

    static CollectionKind fromType(TypeInfo<?> typeInfo) {
        Class<?> rawType = typeInfo.rawType();
        if (rawType.equals(Collection.class)) {
            return COLLECTION;
        }
        if (rawType.equals(Set.class)) {
            return SET;
        }
        if (rawType.equals(List.class)) {
            return LIST;
        }
        throw new IllegalArgumentException("Not a Collection/Set/List: " + typeInfo);
    }
}

