/*
 * Decompiled with CFR 0.152.
 */
package space.arim.dazzleconf.internal.processor;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import space.arim.dazzleconf.internal.util.ImmutableCollections;

class ConfigInvocationHandler
implements InvocationHandler {
    private final Map<String, Object> configMap;

    ConfigInvocationHandler(Map<String, Object> configMap) {
        this.configMap = ImmutableCollections.mapOf(configMap);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getDeclaringClass() == Object.class) {
            if (method.getName().equals("equals")) {
                return ConfigInvocationHandler.implementEquals(proxy, args[0]);
            }
            return this.invokeMethodOnSelf(method, args);
        }
        assert (args == null) : Arrays.deepToString(args);
        return this.configMap.get(method.getName());
    }

    private Object invokeMethodOnSelf(Method method, Object[] args) throws Throwable {
        try {
            return method.invoke((Object)this, args);
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            throw new AssertionError((Object)ex);
        }
        catch (InvocationTargetException ex) {
            Throwable cause = ex.getCause();
            if (cause != null) {
                throw cause;
            }
            throw ex;
        }
    }

    private static boolean implementEquals(Object ourProxy, Object theirConfig) {
        return ourProxy == theirConfig;
    }

    public String toString() {
        return "ConfigInvocationHandler [configMap=" + this.configMap + "]";
    }
}

