/*
 * Decompiled with CFR 0.152.
 */
package space.arim.dazzleconf;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import space.arim.dazzleconf.internal.util.ImmutableCollections;
import space.arim.dazzleconf.serialiser.ValueSerialiser;
import space.arim.dazzleconf.serialiser.ValueSerialiserMap;
import space.arim.dazzleconf.sorter.ConfigurationSorter;
import space.arim.dazzleconf.validator.ValueValidator;

public final class ConfigurationOptions {
    private final ValueSerialiserMap serialisers;
    private final Map<String, ValueValidator> validators;
    private final ConfigurationSorter sorter;
    private final boolean strictParseEnums;
    private final boolean createSingleElementCollections;
    private static final ConfigurationOptions DEFAULTS = new Builder().build();

    ConfigurationOptions(ValueSerialiserMap serialisers, Map<String, ValueValidator> validators, ConfigurationSorter sorter, boolean strictParseEnums, boolean createSingleElementCollections) {
        this.serialisers = serialisers;
        this.validators = validators;
        this.sorter = sorter;
        this.strictParseEnums = strictParseEnums;
        this.createSingleElementCollections = createSingleElementCollections;
    }

    public static ConfigurationOptions defaults() {
        return DEFAULTS;
    }

    public ValueSerialiserMap getSerialisers() {
        return this.serialisers;
    }

    public Map<String, ValueValidator> getValidators() {
        return this.validators;
    }

    @Deprecated
    public ConfigurationSorter getSorter() {
        return this.getConfigurationSorter().orElse(null);
    }

    public Optional<ConfigurationSorter> getConfigurationSorter() {
        return Optional.ofNullable(this.sorter);
    }

    public boolean strictParseEnums() {
        return this.strictParseEnums;
    }

    public boolean createSingleElementCollections() {
        return this.createSingleElementCollections;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.strictParseEnums ? 1231 : 1237);
        result = 31 * result + System.identityHashCode(this.sorter);
        result = 31 * result + this.serialisers.hashCode();
        result = 31 * result + this.validators.hashCode();
        result = 31 * result + (this.createSingleElementCollections ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ConfigurationOptions)) {
            return false;
        }
        ConfigurationOptions other = (ConfigurationOptions)object;
        return this.strictParseEnums == other.strictParseEnums && (this.sorter == null ? other.sorter == null : this.sorter == other.sorter) && this.serialisers.equals(other.serialisers) && this.validators.equals(other.validators) && this.createSingleElementCollections == other.createSingleElementCollections;
    }

    public String toString() {
        return "ConfigurationOptions [serialisers=" + this.serialisers + ", validators=" + this.validators + ", sorter=" + this.sorter + ", strictParseEnums=" + this.strictParseEnums + ", createSingleElementCollections=" + this.createSingleElementCollections + "]";
    }

    public static class Builder {
        private final Map<Class<?>, ValueSerialiser<?>> serialisers = new HashMap();
        private final Map<String, ValueValidator> validators = new HashMap<String, ValueValidator>();
        private ConfigurationSorter sorter;
        private boolean strictParseEnums;
        private boolean createSingleElementCollections;

        public Builder addSerialiser(ValueSerialiser<?> serialiser) {
            Objects.requireNonNull(serialiser, "serialiser");
            ValueSerialiser<?> previous = this.serialisers.putIfAbsent(serialiser.getTargetClass(), serialiser);
            if (previous != null) {
                throw new IllegalArgumentException("ValueSerialiser " + serialiser + " conflicts with " + previous);
            }
            return this;
        }

        public Builder addSerialisers(ValueSerialiser<?> ... serialisers) {
            Objects.requireNonNull(serialisers, "serialisers");
            for (ValueSerialiser<?> serialiser : serialisers) {
                this.addSerialiser(serialiser);
            }
            return this;
        }

        public Builder addSerialisers(Collection<ValueSerialiser<?>> serialisers) {
            Objects.requireNonNull(serialisers, "serialisers");
            for (ValueSerialiser<?> serialiser : serialisers) {
                this.addSerialiser(serialiser);
            }
            return this;
        }

        public Builder clearSerialisers() {
            this.serialisers.clear();
            return this;
        }

        public Builder addValidator(String key, ValueValidator validator) {
            this.validators.put(Objects.requireNonNull(key, "key"), Objects.requireNonNull(validator, "validator"));
            return this;
        }

        public Builder addValidators(Map<String, ? extends ValueValidator> validators) {
            Objects.requireNonNull(validators, "validators");
            for (Map.Entry<String, ? extends ValueValidator> entry : validators.entrySet()) {
                this.addValidator(entry.getKey(), entry.getValue());
            }
            return this;
        }

        public Builder clearValidators() {
            this.validators.clear();
            return this;
        }

        public Builder sorter(ConfigurationSorter sorter) {
            this.sorter = sorter;
            return this;
        }

        public Builder setStrictParseEnums(boolean strictParseEnums) {
            this.strictParseEnums = strictParseEnums;
            return this;
        }

        public Builder setCreateSingleElementCollections(boolean createSingleElementCollections) {
            this.createSingleElementCollections = createSingleElementCollections;
            return this;
        }

        public ConfigurationOptions build() {
            return new ConfigurationOptions(ValueSerialiserMap.of(this.serialisers), ImmutableCollections.mapOf(this.validators), this.sorter, this.strictParseEnums, this.createSingleElementCollections);
        }

        public String toString() {
            return "ConfigurationOptions.Builder [serialisers=" + this.serialisers + ", validators=" + this.validators + ", sorter=" + this.sorter + ", strictParseEnums=" + this.strictParseEnums + ", createSingleElementCollections=" + this.createSingleElementCollections + "]";
        }
    }
}

