/*
 * Decompiled with CFR 0.152.
 */
package spa.lyh.cn.utils_io;

import android.annotation.TargetApi;
import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.provider.DocumentsContract;
import android.provider.MediaStore;
import android.text.TextUtils;
import android.util.Log;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import spa.lyh.cn.utils_io.model.FileData;
import spa.lyh.cn.utils_io.model.FileDetail;

public class IOUtils {
    private static String TAG = "IOUtils";
    private static String android = "/Android";
    public static final int OVERWRITE_FIRST = 1;
    public static final int ADD_ONLY = 2;
    private static final String DEAFULT_FILE_NAME = "deafult";
    private static List<String> list;
    private static HashMap<String, String> mimeTypeList;

    public static Uri getFileUri(Context context, String filePath) {
        String storagePath = Environment.getExternalStorageDirectory().getPath();
        File file = new File(filePath);
        if (file.exists()) {
            if (Build.VERSION.SDK_INT >= 29) {
                if (filePath.startsWith(storagePath + android)) {
                    return Uri.fromFile((File)file);
                }
                FileDetail detail = IOUtils.queryFile(context, filePath);
                if (detail != null) {
                    Uri contentUri = IOUtils.getUri();
                    if (contentUri != null) {
                        return ContentUris.withAppendedId((Uri)contentUri, (long)detail.getId());
                    }
                    return null;
                }
                return null;
            }
            return Uri.fromFile((File)file);
        }
        return null;
    }

    public static String getFilePath(Context context, Uri uri) {
        Cursor cursor;
        if (null == uri) {
            return null;
        }
        String scheme = uri.getScheme();
        String data = null;
        if (scheme == null) {
            data = uri.getPath();
        } else if ("file".equals(scheme)) {
            data = uri.getPath();
        } else if (DocumentsContract.isDocumentUri((Context)context, (Uri)uri)) {
            if (IOUtils.isExternalStorageDocument(uri)) {
                String docId = DocumentsContract.getDocumentId((Uri)uri);
                String[] split = docId.split(":");
                String type = split[0];
                if ("primary".equalsIgnoreCase(type)) {
                    data = Environment.getExternalStorageDirectory() + "/" + split[1];
                }
            } else if (IOUtils.isDownloadsDocument(uri)) {
                String id = DocumentsContract.getDocumentId((Uri)uri);
                if (id.startsWith("raw:")) {
                    return id.replaceFirst("raw:", "");
                }
                Uri contentUri = ContentUris.withAppendedId((Uri)Uri.parse((String)"content://downloads/public_downloads"), (long)Long.valueOf(id));
                data = IOUtils.getDataColumn(context, contentUri, null, null);
            } else if (IOUtils.isMediaDocument(uri)) {
                String docId = DocumentsContract.getDocumentId((Uri)uri);
                String[] split = docId.split(":");
                String type = split[0];
                Uri contentUri = null;
                if ("image".equals(type)) {
                    contentUri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
                } else if ("video".equals(type)) {
                    contentUri = MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
                } else if ("audio".equals(type)) {
                    contentUri = MediaStore.Audio.Media.EXTERNAL_CONTENT_URI;
                }
                String selection = "_id=?";
                String[] selectionArgs = new String[]{split[1]};
                if (contentUri != null) {
                    data = IOUtils.getDataColumn(context, contentUri, "_id=?", selectionArgs);
                }
            }
        } else if ("content".equals(scheme) && null != (cursor = context.getContentResolver().query(uri, new String[]{"_data"}, null, null, null))) {
            int index;
            if (cursor.moveToFirst() && (index = cursor.getColumnIndex("_data")) > -1) {
                data = cursor.getString(index);
            }
            cursor.close();
        }
        return data;
    }

    public static FileInputStream getFileInputStream(Context context, String filePath) {
        String storagePath = Environment.getExternalStorageDirectory().getPath();
        File file = new File(filePath);
        if (file.exists()) {
            if (Build.VERSION.SDK_INT >= 29) {
                if (filePath.startsWith(storagePath + android)) {
                    try {
                        return new FileInputStream(file);
                    }
                    catch (FileNotFoundException e) {
                        e.printStackTrace();
                        return null;
                    }
                }
                FileDetail detail = IOUtils.queryFile(context, filePath);
                if (detail != null) {
                    Uri contentUri = IOUtils.getUri();
                    if (contentUri != null) {
                        Uri fileUri = ContentUris.withAppendedId((Uri)contentUri, (long)detail.getId());
                        try {
                            return (FileInputStream)context.getContentResolver().openInputStream(fileUri);
                        }
                        catch (FileNotFoundException e) {
                            e.printStackTrace();
                            return null;
                        }
                    }
                    return null;
                }
                return null;
            }
            try {
                return new FileInputStream(file);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    public static FileInputStream getFileInputStream(Context context, Uri uri) {
        FileInputStream fis = null;
        try {
            fis = (FileInputStream)context.getContentResolver().openInputStream(uri);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return fis;
    }

    public static FileOutputStream getFileOutputStream(Context context, String filePath) {
        String storagePath = Environment.getExternalStorageDirectory().getPath();
        File file = new File(filePath);
        if (file.exists()) {
            if (Build.VERSION.SDK_INT >= 29) {
                if (filePath.startsWith(storagePath + android)) {
                    try {
                        return new FileOutputStream(file);
                    }
                    catch (FileNotFoundException e) {
                        e.printStackTrace();
                        return null;
                    }
                }
                FileDetail detail = IOUtils.queryFile(context, filePath);
                if (detail != null) {
                    Uri contentUri = IOUtils.getUri();
                    if (contentUri != null) {
                        Uri fileUri = ContentUris.withAppendedId((Uri)contentUri, (long)detail.getId());
                        try {
                            return (FileOutputStream)context.getContentResolver().openOutputStream(fileUri);
                        }
                        catch (FileNotFoundException e) {
                            e.printStackTrace();
                            return null;
                        }
                    }
                    return null;
                }
                return null;
            }
            try {
                return new FileOutputStream(file);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    public static FileOutputStream getFileOutputStream(Context context, Uri uri) {
        FileOutputStream fos = null;
        try {
            fos = (FileOutputStream)context.getContentResolver().openOutputStream(uri);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return fos;
    }

    public static FileData createFileOutputStream(Context context, String dirPath, String fileName, int mod) {
        if (IOUtils.isApkInDebug(context)) {
            Log.e((String)TAG, (String)"MOD\u4ec5\u5f71\u54cd\u5728\u5e94\u7528\u5185\u90e8\u5b58\u50a8\u903b\u8f91\uff0c\u516c\u5171\u8def\u5f84\u6c38\u4e45\u4e3aADD_ONLY\u3002");
        }
        String storagePath = Environment.getExternalStorageDirectory().getPath();
        String lowFileName = IOUtils.getLowSuffixRightFileName(fileName);
        if (Build.VERSION.SDK_INT >= 29) {
            Uri insertUri;
            if (dirPath.startsWith(storagePath + android)) {
                return IOUtils.ioUnder9(dirPath, lowFileName, mod);
            }
            String mimeType = IOUtils.getMimeType(lowFileName);
            ContentValues values = new ContentValues();
            String relativePath = dirPath.substring(storagePath.length() + 1);
            values.put("_display_name", lowFileName);
            values.put("mime_type", mimeType);
            values.put("relative_path", relativePath);
            Uri external = IOUtils.getUri();
            if (external == null) {
                return null;
            }
            ContentResolver resolver = context.getContentResolver();
            try {
                insertUri = resolver.insert(external, values);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
            if (insertUri != null) {
                FileData data = new FileData();
                data.setFilePath(IOUtils.getFilePath(context, insertUri));
                data.setFileName(IOUtils.getFileName(data.getFilePath()));
                try {
                    data.setFos((FileOutputStream)resolver.openOutputStream(insertUri));
                    return data;
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            return null;
        }
        if (dirPath.startsWith(storagePath + android)) {
            return IOUtils.ioUnder9(dirPath, lowFileName, mod);
        }
        return IOUtils.ioUnder9(dirPath, lowFileName, 2);
    }

    public static boolean delete(Context context, String filePath) {
        String storagePath = Environment.getExternalStorageDirectory().getPath();
        if (Build.VERSION.SDK_INT >= 29) {
            if (filePath.startsWith(storagePath + android)) {
                File file = new File(filePath);
                if (file.exists()) {
                    return file.delete();
                }
                return false;
            }
            Uri external = IOUtils.getUri();
            ContentResolver resolver = context.getContentResolver();
            if (external != null) {
                String selection = "_data = ?";
                int yes = resolver.delete(external, selection, new String[]{filePath});
                if (yes > 0) {
                    File file = new File(filePath);
                    if (file.exists()) {
                        IOUtils.sendSystemScanBroadcast(context, filePath);
                        if (IOUtils.isApkInDebug(context)) {
                            Log.e((String)TAG, (String)"\u76ee\u524d\u901a\u8fc7\u5b9e\u8df5\u53d1\u73b0Android10\u7cfb\u7edf\u4e0b\u7684\u67d0\u4e9b\u516c\u5171\u6587\u4ef6\u5939\uff0c\u65e0\u6cd5\u6309\u7167\u4ee3\u7801\u9884\u671f\u8fdb\u884c\u6587\u4ef6\u79fb\u9664\u3002\u57fa\u672c\u786e\u8ba4\u662fAndroid10\u7684BUG\uff0cAndroid11\u6d4b\u8bd5\u5df2\u5c06\u6b64\u95ee\u9898\u4fee\u590d\u3002\u5982\u679c\u9879\u76ee\u5b9e\u9645\u4f7f\u7528\u4e2d\u78b0\u5230\u4e86\u8fd9\u4e2a\u95ee\u9898,\u8bf7\u907f\u514d\u4f7f\u7528\u8fd9\u4e2a\u6587\u4ef6\u5939\u3002\u6216\u8005\u5f15\u5bfc\u7528\u6237\u624b\u52a8\u79fb\u9664\u8be5\u6587\u4ef6\u3002");
                        }
                        return false;
                    }
                    return true;
                }
                return false;
            }
            return false;
        }
        File file = new File(filePath);
        if (file.exists()) {
            return file.delete();
        }
        return false;
    }

    public static boolean delete(Context context, Uri uri) {
        String filePath = IOUtils.getFilePath(context, uri);
        int yes = context.getContentResolver().delete(uri, null, null);
        if (yes > 0) {
            if (TextUtils.isEmpty((CharSequence)filePath)) {
                return true;
            }
            File file = new File(filePath);
            if (file.exists()) {
                IOUtils.sendSystemScanBroadcast(context, filePath);
                if (IOUtils.isApkInDebug(context)) {
                    Log.e((String)TAG, (String)"\u76ee\u524d\u901a\u8fc7\u5b9e\u8df5\u53d1\u73b0Android10\u7cfb\u7edf\u4e0b\u7684\u67d0\u4e9b\u516c\u5171\u6587\u4ef6\u5939\uff0c\u65e0\u6cd5\u6309\u7167\u4ee3\u7801\u9884\u671f\u8fdb\u884c\u6587\u4ef6\u79fb\u9664\u3002\u57fa\u672c\u786e\u8ba4\u662fAndroid10\u7684BUG\uff0cAndroid11\u6d4b\u8bd5\u5df2\u5c06\u6b64\u95ee\u9898\u4fee\u590d\u3002\u5982\u679c\u9879\u76ee\u5b9e\u9645\u4f7f\u7528\u4e2d\u78b0\u5230\u4e86\u8fd9\u4e2a\u95ee\u9898,\u8bf7\u907f\u514d\u4f7f\u7528\u8fd9\u4e2a\u6587\u4ef6\u5939\u3002\u6216\u8005\u5f15\u5bfc\u7528\u6237\u624b\u52a8\u79fb\u9664\u8be5\u6587\u4ef6\u3002");
                }
                return false;
            }
            return true;
        }
        return false;
    }

    @TargetApi(value=29)
    private static Uri getUri() {
        return MediaStore.Files.getContentUri((String)"external");
    }

    private static String syncFileName(String contnet, boolean isSuffix) {
        String[] patterns;
        String syncContent = contnet;
        if (syncContent.equals("")) {
            return syncContent;
        }
        int flag = contnet.length();
        for (String pattern : patterns = new String[]{"\\", "/", ":", "*", "?", "\"", "<", ">", "|"}) {
            int index = contnet.indexOf(pattern);
            if (index == -1 || index >= flag) continue;
            flag = index;
        }
        if (isSuffix) {
            if (flag == 1) {
                return "";
            }
        } else if (flag == 0) {
            return DEAFULT_FILE_NAME;
        }
        if (flag < contnet.length()) {
            syncContent = syncContent.substring(0, flag);
        }
        return syncContent;
    }

    private static FileData ioUnder9(String dirPath, String fileName, int mod) {
        IOUtils.checkLocalFilePath(dirPath);
        FileData data = new FileData();
        switch (mod) {
            case 1: {
                data.setFileName(fileName);
                break;
            }
            case 2: {
                data.setFileName(IOUtils.createFileName(dirPath, fileName));
            }
        }
        data.setFilePath(dirPath + "/" + data.getFileName());
        try {
            data.setFos(new FileOutputStream(new File(data.getFilePath())));
            return data;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String createFileName(String dirPath, String fileName) {
        if (list == null) {
            list = new ArrayList<String>();
        } else {
            list.clear();
        }
        File file = new File(dirPath);
        if (file.list() != null) {
            for (String string : file.list()) {
                if (!new File(file.getAbsolutePath(), string).isFile()) continue;
                list.add(string);
            }
        }
        if (list.size() == 0) {
            return IOUtils.getLowSuffixRightFileName(fileName);
        }
        return IOUtils.returnName(fileName, 0);
    }

    private static String returnName(String fileName, int index) {
        int mIndex = index;
        String newFileName = fileName;
        for (String string : list) {
            String readName = IOUtils.getLowSuffixRightFileName(string);
            if (!fileName.equals(readName)) continue;
            String front = IOUtils.getFront(newFileName);
            String behind = IOUtils.getBehind(newFileName);
            if (index == 0 && ++mIndex == 1) {
                newFileName = front + " (" + mIndex + ")" + behind;
                continue;
            }
            int place = newFileName.lastIndexOf("(");
            newFileName = front.substring(0, place + 1) + mIndex + ")" + behind;
        }
        if (mIndex == index) {
            return newFileName;
        }
        return IOUtils.returnName(newFileName, mIndex);
    }

    public static void checkLocalFilePath(String localFilePath) {
        File path = new File(localFilePath);
        if (!path.exists()) {
            path.mkdirs();
        }
    }

    public static String getMimeType(String fileName) {
        int spot = fileName.lastIndexOf(".");
        String behind = spot == 0 ? fileName.substring(spot) : (spot == fileName.length() - 1 ? "" : (spot != -1 ? fileName.substring(spot) : ""));
        if (behind.equals(".")) {
            behind = "";
        }
        behind = IOUtils.syncFileName(behind, true);
        String mimeType = mimeTypeList.get(behind = behind.toLowerCase());
        if (mimeType == null) {
            mimeType = "*/*";
        }
        return mimeType;
    }

    public static String getFileName(String filePath) {
        String[] strArr = filePath.split("/");
        return strArr[strArr.length - 1];
    }

    private static String getLowSuffixRightFileName(String fileName) {
        String front;
        String behind = "";
        int spot = fileName.lastIndexOf(".");
        if (spot == 0) {
            front = DEAFULT_FILE_NAME;
            behind = fileName.substring(spot);
        } else if (spot == fileName.length() - 1) {
            front = fileName.substring(0, spot);
        } else if (spot != -1) {
            front = fileName.substring(0, spot);
            behind = fileName.substring(spot);
        } else {
            front = fileName;
        }
        if (behind.equals(".")) {
            behind = "";
        }
        front = IOUtils.syncFileName(front, false);
        behind = IOUtils.syncFileName(behind, true);
        behind = behind.toLowerCase();
        return front + behind;
    }

    public static String getFront(String fileName) {
        int spot = fileName.lastIndexOf(".");
        String front = spot != -1 ? fileName.substring(0, spot) : fileName;
        return front;
    }

    public static String getBehind(String fileName) {
        int spot = fileName.lastIndexOf(".");
        String behind = spot != -1 ? fileName.substring(spot) : "";
        return behind;
    }

    @TargetApi(value=29)
    private static FileDetail queryFile(Context context, String filePath) {
        return IOUtils.queryFile(context, filePath, 1);
    }

    @TargetApi(value=29)
    private static FileDetail queryFile(Context context, String filePath, int times) {
        if (times <= 2) {
            FileDetail detail = null;
            try {
                String dataKey = "_data";
                String selection = dataKey + " = ?";
                Uri uri = IOUtils.getUri();
                if (uri != null) {
                    Cursor cursor = context.getContentResolver().query(uri, new String[]{"_id", "_data", "mime_type", "_display_name", "title", "relative_path"}, selection, new String[]{filePath}, null);
                    if (cursor != null && cursor.moveToFirst()) {
                        detail = new FileDetail();
                        do {
                            detail.setId(cursor.getInt(cursor.getColumnIndex("_id")));
                            detail.setData(cursor.getString(cursor.getColumnIndex("_data")));
                            detail.setMineType(cursor.getString(cursor.getColumnIndex("mime_type")));
                            detail.setDisplayName(cursor.getString(cursor.getColumnIndex("_display_name")));
                            detail.setTitle(cursor.getString(cursor.getColumnIndex("title")));
                            detail.setRelativePath(cursor.getString(cursor.getColumnIndex("relative_path")));
                        } while (cursor.moveToNext());
                    }
                    if (cursor != null) {
                        cursor.close();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
            if (detail != null) {
                return detail;
            }
            File file = new File(filePath);
            if (file.exists()) {
                IOUtils.sendSystemScanBroadcast(context, filePath);
                return IOUtils.queryFile(context, filePath, times + 1);
            }
            return null;
        }
        return null;
    }

    public static void sendSystemScanBroadcast(Context context, String filePath) {
        File file = new File(filePath);
        if (file.exists()) {
            Uri data = Uri.fromFile((File)new File(filePath));
            context.sendBroadcast(new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE", data));
        }
    }

    private static boolean isApkInDebug(Context context) {
        try {
            ApplicationInfo info = context.getApplicationInfo();
            return (info.flags & 2) != 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean isExternalStorageDocument(Uri uri) {
        return "com.android.externalstorage.documents".equals(uri.getAuthority());
    }

    private static boolean isDownloadsDocument(Uri uri) {
        return "com.android.providers.downloads.documents".equals(uri.getAuthority());
    }

    private static boolean isMediaDocument(Uri uri) {
        return "com.android.providers.media.documents".equals(uri.getAuthority());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getDataColumn(Context context, Uri uri, String selection, String[] selectionArgs) {
        Cursor cursor = null;
        String column = "_data";
        String[] projection = new String[]{"_data"};
        try {
            cursor = context.getContentResolver().query(uri, projection, selection, selectionArgs, null);
            if (cursor != null && cursor.moveToFirst()) {
                int column_index = cursor.getColumnIndexOrThrow("_data");
                String string = cursor.getString(column_index);
                return string;
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return null;
    }

    static {
        mimeTypeList = new HashMap();
        mimeTypeList.put(".3gp", "video/3gpp");
        mimeTypeList.put(".apk", "application/vnd.android.package-archive");
        mimeTypeList.put(".asf", "video/x-ms-asf");
        mimeTypeList.put(".avi", "video/x-msvideo");
        mimeTypeList.put(".bin", "application/octet-stream");
        mimeTypeList.put(".bmp", "image/bmp");
        mimeTypeList.put(".c", "text/plain");
        mimeTypeList.put(".class", "application/octet-stream");
        mimeTypeList.put(".conf", "text/plain");
        mimeTypeList.put(".cpp", "text/plain");
        mimeTypeList.put(".doc", "application/msword");
        mimeTypeList.put(".docx", "application/vnd.openxmlformats-officedocument.wordprocessingml.document");
        mimeTypeList.put(".xls", "application/vnd.ms-excel");
        mimeTypeList.put(".xlsx", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        mimeTypeList.put(".exe", "application/octet-stream");
        mimeTypeList.put(".flac", "audio/quicktime");
        mimeTypeList.put(".flv", "video/x-flv");
        mimeTypeList.put(".gif", "image/gif");
        mimeTypeList.put(".gtar", "application/x-gtar");
        mimeTypeList.put(".gz", "application/x-gzip");
        mimeTypeList.put(".h", "text/plain");
        mimeTypeList.put(".htm", "text/html");
        mimeTypeList.put(".html", "text/html");
        mimeTypeList.put(".jar", "application/java-archive");
        mimeTypeList.put(".java", "text/plain");
        mimeTypeList.put(".jpeg", "image/jpeg");
        mimeTypeList.put(".jpg", "image/jpeg");
        mimeTypeList.put(".js", "application/x-javascript");
        mimeTypeList.put(".ipk", "application/vnd.shana.informed.package");
        mimeTypeList.put(".log", "text/plain");
        mimeTypeList.put(".m3u", "audio/x-mpegurl");
        mimeTypeList.put(".m4a", "audio/mp4a-latm");
        mimeTypeList.put(".m4b", "audio/mp4a-latm");
        mimeTypeList.put(".m4p", "audio/mp4a-latm");
        mimeTypeList.put(".m4u", "video/x-m4v");
        mimeTypeList.put(".mov", "video/quicktime");
        mimeTypeList.put(".mp2", "audio/x-mpeg");
        mimeTypeList.put(".mp3", "audio/x-mpeg");
        mimeTypeList.put(".mp4", "video/mp4");
        mimeTypeList.put(".mpc", "application/vnd.mpohun.certificate");
        mimeTypeList.put(".mpe", "video/mpeg");
        mimeTypeList.put(".mpeg", "video/mpeg");
        mimeTypeList.put(".mpg", "video/mpeg");
        mimeTypeList.put(".mpg4", "video/mp4");
        mimeTypeList.put(".mpga", "audio/mpeg");
        mimeTypeList.put(".msg", "application/vnd.ms-outlook");
        mimeTypeList.put(".ogg", "audio/ogg");
        mimeTypeList.put(".pdf", "application/pdf");
        mimeTypeList.put(".png", "image/png");
        mimeTypeList.put(".pps", "application/vnd.ms-powerpoint");
        mimeTypeList.put(".ppt", "application/vnd.ms-powerpoint");
        mimeTypeList.put(".pptx", "application/vnd.openxmlformats-officedocument.presentationml.presentation");
        mimeTypeList.put(".prop", "text/plain");
        mimeTypeList.put(".rc", "text/plain");
        mimeTypeList.put(".rmvb", "audio/x-pn-realaudio");
        mimeTypeList.put(".rtf", "application/rtf");
        mimeTypeList.put(".sh", "text/plain");
        mimeTypeList.put(".tar", "application/x-tar");
        mimeTypeList.put(".tgz", "application/x-compressed");
        mimeTypeList.put(".txt", "text/plain");
        mimeTypeList.put(".wav", "audio/x-wav");
        mimeTypeList.put(".wma", "audio/x-ms-wma");
        mimeTypeList.put(".wmv", "audio/x-ms-wmv");
        mimeTypeList.put(".wps", "application/vnd.ms-works");
        mimeTypeList.put(".xml", "text/plain");
        mimeTypeList.put(".z", "application/x-compress");
        mimeTypeList.put(".zip", "application/x-zip-compressed");
        mimeTypeList.put("", "*/*");
    }
}

