/*
 * Decompiled with CFR 0.152.
 */
package spa.lyh.cn.utils_io;

import android.annotation.TargetApi;
import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.os.ParcelFileDescriptor;
import android.provider.MediaStore;
import android.util.Log;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class IOUtils {
    private static String android = "/Android";
    private String mainPath;
    private String fileName;
    private static final String DEAFULT_FILE_NAME = "deafult";
    private List<String> list;
    private static HashMap<String, String> mimeTypeList = new HashMap();

    public FileOutputStream getFileOutputStream(Context context, String dirPath, String fileName) {
        String storagePath = Environment.getExternalStorageDirectory().getPath();
        String lowFileName = this.getLowSuffixRightFileName(fileName);
        this.mainPath = dirPath.startsWith("/sdcard") ? storagePath + dirPath.substring(7) : dirPath;
        if (Build.VERSION.SDK_INT >= 29) {
            if (IOUtils.verifyStoragePath(this.mainPath)) {
                if (this.mainPath.startsWith(storagePath + android)) {
                    try {
                        return new FileOutputStream(this.ioUnder9(this.mainPath, lowFileName));
                    }
                    catch (FileNotFoundException e) {
                        e.printStackTrace();
                        return null;
                    }
                }
                String mimeType = this.getMimeType(lowFileName);
                ContentValues values = new ContentValues();
                values.put("_display_name", lowFileName);
                values.put("mime_type", mimeType);
                values.put("relative_path", this.mainPath.substring(storagePath.length() + 1));
                Uri external = this.getUri(this.mainPath, mimeType);
                if (external == null) {
                    return null;
                }
                ContentResolver resolver = context.getContentResolver();
                Uri insertUri = resolver.insert(external, values);
                if (insertUri != null) {
                    this.mainPath = this.getRealFilePath(context, insertUri);
                    this.fileName = this.getName(this.mainPath);
                    try {
                        return (FileOutputStream)resolver.openOutputStream(insertUri);
                    }
                    catch (FileNotFoundException e) {
                        e.printStackTrace();
                        return null;
                    }
                }
                return null;
            }
            return null;
        }
        if (IOUtils.verifyStoragePath(this.mainPath)) {
            try {
                return new FileOutputStream(this.ioUnder9(this.mainPath, lowFileName));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    public boolean delete(Context context, String filePath) {
        String storagePath = Environment.getExternalStorageDirectory().getPath();
        String tempPath = filePath.startsWith("/sdcard") ? storagePath + filePath.substring(7) : filePath;
        if (Build.VERSION.SDK_INT >= 29) {
            String dirPath = tempPath.substring(0, tempPath.lastIndexOf("/"));
            String displayName = tempPath.substring(tempPath.lastIndexOf("/") + 1);
            if (IOUtils.verifyStoragePath(dirPath)) {
                if (dirPath.startsWith(storagePath + android)) {
                    File file = new File(tempPath);
                    if (file.exists()) {
                        return file.delete();
                    }
                    return false;
                }
                Uri external = this.getUri(dirPath, this.getMimeType(displayName));
                if (external == null) {
                    return false;
                }
                ContentResolver resolver = context.getContentResolver();
                if (external != null) {
                    String relativePath = dirPath.replace(storagePath + "/", "") + "/";
                    String[] params = new String[]{displayName, relativePath};
                    int yes = resolver.delete(external, "_display_name = ? and relative_path = ?", params);
                    Log.e((String)"liyuhao", (String)("" + yes));
                    return yes > 0;
                }
                return false;
            }
            return false;
        }
        if (IOUtils.verifyStoragePath(tempPath)) {
            File file = new File(tempPath);
            if (file.exists()) {
                return file.delete();
            }
            return false;
        }
        return false;
    }

    @TargetApi(value=29)
    private Uri getUri(String path, String mimeType) {
        String pubPath = Environment.getExternalStorageDirectory().getPath();
        if (path.startsWith(pubPath + "/" + Environment.DIRECTORY_DOWNLOADS)) {
            return MediaStore.Downloads.EXTERNAL_CONTENT_URI;
        }
        if (path.startsWith(pubPath + "/" + Environment.DIRECTORY_DCIM)) {
            if (mimeType.startsWith("video")) {
                return MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
            }
            return MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
        }
        if (path.startsWith(pubPath + "/" + Environment.DIRECTORY_MOVIES)) {
            return MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
        }
        if (path.startsWith(pubPath + "/" + Environment.DIRECTORY_PICTURES)) {
            return MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
        }
        if (path.startsWith(pubPath + "/" + Environment.DIRECTORY_ALARMS)) {
            return MediaStore.Audio.Media.EXTERNAL_CONTENT_URI;
        }
        if (path.startsWith(pubPath + "/" + Environment.DIRECTORY_MUSIC)) {
            return MediaStore.Audio.Media.EXTERNAL_CONTENT_URI;
        }
        if (path.startsWith(pubPath + "/" + Environment.DIRECTORY_NOTIFICATIONS)) {
            return MediaStore.Audio.Media.EXTERNAL_CONTENT_URI;
        }
        if (path.startsWith(pubPath + "/" + Environment.DIRECTORY_PODCASTS)) {
            return MediaStore.Audio.Media.EXTERNAL_CONTENT_URI;
        }
        if (path.startsWith(pubPath + "/" + Environment.DIRECTORY_RINGTONES)) {
            return MediaStore.Audio.Media.EXTERNAL_CONTENT_URI;
        }
        if (path.startsWith(pubPath + "/" + Environment.DIRECTORY_DOCUMENTS)) {
            return MediaStore.Files.getContentUri((String)"external");
        }
        return null;
    }

    private String getMimeType(String fileName) {
        int spot = fileName.lastIndexOf(".");
        String behind = spot == 0 ? fileName.substring(spot) : (spot == fileName.length() - 1 ? "" : (spot != -1 ? fileName.substring(spot) : ""));
        if (behind.equals(".")) {
            behind = "";
        }
        behind = this.syncFileName(behind, true);
        String mimeType = mimeTypeList.get(behind = behind.toLowerCase());
        if (mimeType == null) {
            mimeType = "*/*";
        }
        return mimeType;
    }

    private String syncFileName(String contnet, boolean isSuffix) {
        String[] patterns;
        String syncContent = contnet;
        if (syncContent.equals("")) {
            return syncContent;
        }
        int flag = contnet.length();
        for (String pattern : patterns = new String[]{"\\", "/", ":", "*", "?", "\"", "<", ">", "|"}) {
            int index = contnet.indexOf(pattern);
            if (index == -1 || index >= flag) continue;
            flag = index;
        }
        if (isSuffix) {
            if (flag == 1) {
                return "";
            }
        } else if (flag == 0) {
            return DEAFULT_FILE_NAME;
        }
        if (flag < contnet.length()) {
            syncContent = syncContent.substring(0, flag);
        }
        return syncContent;
    }

    private File ioUnder9(String dirPath, String fileName) {
        IOUtils.checkLocalFilePath(dirPath);
        this.fileName = this.createFileName(dirPath, fileName);
        this.mainPath = dirPath + "/" + this.fileName;
        return new File(this.mainPath);
    }

    private String createFileName(String dirPath, String fileName) {
        if (this.list == null) {
            this.list = new ArrayList<String>();
        } else {
            this.list.clear();
        }
        File file = new File(dirPath);
        if (file.list() != null) {
            for (String string : file.list()) {
                if (!new File(file.getAbsolutePath(), string).isFile()) continue;
                this.list.add(string);
            }
        }
        if (this.list.size() == 0) {
            return this.getLowSuffixRightFileName(fileName);
        }
        return this.returnName(fileName, 0);
    }

    private String returnName(String fileName, int index) {
        int mIndex = index;
        String newFileName = fileName;
        for (String string : this.list) {
            String readName = this.getLowSuffixRightFileName(string);
            if (!fileName.equals(readName)) continue;
            String front = this.getFront(newFileName);
            String behind = this.getBehind(newFileName);
            if (index == 0 && ++mIndex == 1) {
                newFileName = front + " (" + mIndex + ")" + behind;
                continue;
            }
            int place = newFileName.lastIndexOf("(");
            newFileName = front.substring(0, place + 1) + mIndex + ")" + behind;
        }
        if (mIndex == index) {
            return newFileName;
        }
        return this.returnName(newFileName, mIndex);
    }

    public String getFilePath() {
        if (this.mainPath != null) {
            return this.mainPath;
        }
        return "";
    }

    public String getFileName() {
        if (this.fileName != null) {
            return this.fileName;
        }
        return "";
    }

    private static boolean verifyStoragePath(String path) {
        if (path.startsWith(Environment.getExternalStorageDirectory().getPath())) {
            return true;
        }
        Log.e((String)"IOUtils", (String)"\u7edd\u5bf9\u8def\u5f84\u53ef\u80fd\u5b58\u5728\u9519\u8bef");
        return false;
    }

    private static void checkLocalFilePath(String localFilePath) {
        File path = new File(localFilePath);
        if (!path.exists()) {
            path.mkdirs();
        }
    }

    private String getRealFilePath(Context context, Uri uri) {
        Cursor cursor;
        if (null == uri) {
            return null;
        }
        String scheme = uri.getScheme();
        String data = null;
        if (scheme == null) {
            data = uri.getPath();
        } else if ("file".equals(scheme)) {
            data = uri.getPath();
        } else if ("content".equals(scheme) && null != (cursor = context.getContentResolver().query(uri, new String[]{"_data"}, null, null, null))) {
            int index;
            if (cursor.moveToFirst() && (index = cursor.getColumnIndex("_data")) > -1) {
                data = cursor.getString(index);
            }
            cursor.close();
        }
        return data;
    }

    private String getName(String filePath) {
        String[] strArr = filePath.split("/");
        return strArr[strArr.length - 1];
    }

    private String getLowSuffixRightFileName(String fileName) {
        String front;
        String behind = "";
        int spot = fileName.lastIndexOf(".");
        if (spot == 0) {
            front = DEAFULT_FILE_NAME;
            behind = fileName.substring(spot);
        } else if (spot == fileName.length() - 1) {
            front = fileName.substring(0, spot);
        } else if (spot != -1) {
            front = fileName.substring(0, spot);
            behind = fileName.substring(spot);
        } else {
            front = fileName;
        }
        if (behind.equals(".")) {
            behind = "";
        }
        front = this.syncFileName(front, false);
        behind = this.syncFileName(behind, true);
        behind = behind.toLowerCase();
        return front + behind;
    }

    private String getFront(String fileName) {
        int spot = fileName.lastIndexOf(".");
        String front = spot != -1 ? fileName.substring(0, spot) : fileName;
        return front;
    }

    private String getBehind(String fileName) {
        int spot = fileName.lastIndexOf(".");
        String behind = spot != -1 ? fileName.substring(spot) : "";
        return behind;
    }

    public void querySignImage(Context context, String filePath) {
        try {
            String queryPathKey = Build.VERSION.SDK_INT >= 29 ? "_display_name" : "_data";
            String selection = queryPathKey + " = ?";
            Cursor cursor = context.getContentResolver().query(MediaStore.Files.getContentUri((String)"external"), new String[]{"_id", "_data", "mime_type", "_display_name", "title"}, selection, new String[]{filePath}, null);
            if (cursor != null && cursor.moveToFirst()) {
                do {
                    int id = cursor.getInt(cursor.getColumnIndex("_id"));
                    String path = cursor.getString(cursor.getColumnIndex("_data"));
                    String type = cursor.getString(cursor.getColumnIndex("mime_type"));
                    String name = cursor.getString(cursor.getColumnIndex("_display_name"));
                    String title = cursor.getString(cursor.getColumnIndex("title"));
                    Log.e((String)"liyuhao", (String)("id:" + id));
                    Log.e((String)"liyuhao", (String)("path:" + path));
                    Log.e((String)"liyuhao", (String)("type:" + type));
                    Log.e((String)"liyuhao", (String)("name:" + name));
                    Log.e((String)"liyuhao", (String)("title:" + title));
                    Uri contentUri = ContentUris.withAppendedId((Uri)MediaStore.Images.Media.EXTERNAL_CONTENT_URI, (long)id);
                    if (contentUri == null) continue;
                    Log.e((String)"liyuhao", (String)"\u5f97\u5230uri");
                    ParcelFileDescriptor parcelFd = context.getContentResolver().openFileDescriptor(contentUri, "r");
                    if (parcelFd == null) continue;
                    int fd = parcelFd.detachFd();
                    Log.e((String)"liyuhao", (String)("TTid:" + fd));
                } while (cursor.moveToNext());
            }
            if (cursor != null) {
                cursor.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        mimeTypeList.put(".3gp", "video/3gpp");
        mimeTypeList.put(".apk", "application/vnd.android.package-archive");
        mimeTypeList.put(".asf", "video/x-ms-asf");
        mimeTypeList.put(".avi", "video/x-msvideo");
        mimeTypeList.put(".bin", "application/octet-stream");
        mimeTypeList.put(".bmp", "image/bmp");
        mimeTypeList.put(".c", "text/plain");
        mimeTypeList.put(".class", "application/octet-stream");
        mimeTypeList.put(".conf", "text/plain");
        mimeTypeList.put(".cpp", "text/plain");
        mimeTypeList.put(".doc", "application/msword");
        mimeTypeList.put(".docx", "application/vnd.openxmlformats-officedocument.wordprocessingml.document");
        mimeTypeList.put(".xls", "application/vnd.ms-excel");
        mimeTypeList.put(".xlsx", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        mimeTypeList.put(".exe", "application/octet-stream");
        mimeTypeList.put(".flv", "video/x-flv");
        mimeTypeList.put(".gif", "image/gif");
        mimeTypeList.put(".gtar", "application/x-gtar");
        mimeTypeList.put(".gz", "application/x-gzip");
        mimeTypeList.put(".h", "text/plain");
        mimeTypeList.put(".htm", "text/html");
        mimeTypeList.put(".html", "text/html");
        mimeTypeList.put(".jar", "application/java-archive");
        mimeTypeList.put(".java", "text/plain");
        mimeTypeList.put(".jpeg", "image/jpeg");
        mimeTypeList.put(".jpg", "image/jpeg");
        mimeTypeList.put(".js", "application/x-javascript");
        mimeTypeList.put(".ipk", "application/vnd.shana.informed.package");
        mimeTypeList.put(".log", "text/plain");
        mimeTypeList.put(".m3u", "audio/x-mpegurl");
        mimeTypeList.put(".m4a", "audio/mp4a-latm");
        mimeTypeList.put(".m4b", "audio/mp4a-latm");
        mimeTypeList.put(".m4p", "audio/mp4a-latm");
        mimeTypeList.put(".m4u", "video/x-m4v");
        mimeTypeList.put(".mov", "video/quicktime");
        mimeTypeList.put(".mp2", "audio/x-mpeg");
        mimeTypeList.put(".mp3", "audio/x-mpeg");
        mimeTypeList.put(".mp4", "video/mp4");
        mimeTypeList.put(".mpc", "application/vnd.mpohun.certificate");
        mimeTypeList.put(".mpe", "video/mpeg");
        mimeTypeList.put(".mpeg", "video/mpeg");
        mimeTypeList.put(".mpg", "video/mpeg");
        mimeTypeList.put(".mpg4", "video/mp4");
        mimeTypeList.put(".mpga", "audio/mpeg");
        mimeTypeList.put(".msg", "application/vnd.ms-outlook");
        mimeTypeList.put(".ogg", "audio/ogg");
        mimeTypeList.put(".pdf", "application/pdf");
        mimeTypeList.put(".png", "image/png");
        mimeTypeList.put(".pps", "application/vnd.ms-powerpoint");
        mimeTypeList.put(".ppt", "application/vnd.ms-powerpoint");
        mimeTypeList.put(".pptx", "application/vnd.openxmlformats-officedocument.presentationml.presentation");
        mimeTypeList.put(".prop", "text/plain");
        mimeTypeList.put(".rc", "text/plain");
        mimeTypeList.put(".rmvb", "audio/x-pn-realaudio");
        mimeTypeList.put(".rtf", "application/rtf");
        mimeTypeList.put(".sh", "text/plain");
        mimeTypeList.put(".tar", "application/x-tar");
        mimeTypeList.put(".tgz", "application/x-compressed");
        mimeTypeList.put(".txt", "text/plain");
        mimeTypeList.put(".wav", "audio/x-wav");
        mimeTypeList.put(".wma", "audio/x-ms-wma");
        mimeTypeList.put(".wmv", "audio/x-ms-wmv");
        mimeTypeList.put(".wps", "application/vnd.ms-works");
        mimeTypeList.put(".xml", "text/plain");
        mimeTypeList.put(".z", "application/x-compress");
        mimeTypeList.put(".zip", "application/x-zip-compressed");
        mimeTypeList.put("", "*/*");
    }
}

