/*
 * Decompiled with CFR 0.152.
 */
package spa.lyh.cn.statusbarlightmode.helpers.lightmode;

import android.app.Activity;
import android.os.Build;
import android.util.Log;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import spa.lyh.cn.statusbarlightmode.helpers.lightmode.ILightModeHelper;

public class FlymeHelper
implements ILightModeHelper {
    private static Method mSetStatusBarDarkIcon;
    private static Field mStatusBarColorFiled;
    private static int SYSTEM_UI_FLAG_LIGHT_STATUS_BAR;

    @Override
    public boolean setLightMode(Activity activity, boolean isLightMode) {
        if (Build.VERSION.SDK_INT >= 19) {
            try {
                mSetStatusBarDarkIcon = Activity.class.getMethod("setStatusBarDarkIcon", Boolean.TYPE);
            }
            catch (NoSuchMethodException e) {
                Log.e((String)"LightModeException", (String)"Can not found Flyme Method");
                return false;
            }
            try {
                mStatusBarColorFiled = WindowManager.LayoutParams.class.getField("statusBarColor");
            }
            catch (NoSuchFieldException e) {
                Log.e((String)"LightModeException", (String)"Can not found Flyme Method");
                return false;
            }
            if (mSetStatusBarDarkIcon != null) {
                try {
                    mSetStatusBarDarkIcon.invoke((Object)activity, isLightMode);
                    return true;
                }
                catch (Exception e) {
                    Log.e((String)"LightModeException", (String)"Failed to match Flyme");
                    return false;
                }
            }
            return this.setStatusBarDarkIcon(activity.getWindow(), isLightMode);
        }
        return false;
    }

    private boolean setStatusBarDarkIcon(Window window, boolean dark) {
        if (Build.VERSION.SDK_INT < 23) {
            return this.changeMeizuFlag(window.getAttributes(), "MEIZU_FLAG_DARK_STATUS_BAR_ICON", dark);
        }
        View decorView = window.getDecorView();
        if (decorView != null) {
            this.setStatusBarColor(window, 0);
            return this.setStatusBarDarkIcon(decorView, dark);
        }
        return false;
    }

    private boolean setStatusBarDarkIcon(View view, boolean dark) {
        int oldVis;
        int newVis = oldVis = view.getSystemUiVisibility();
        newVis = dark ? (newVis |= SYSTEM_UI_FLAG_LIGHT_STATUS_BAR) : (newVis &= ~SYSTEM_UI_FLAG_LIGHT_STATUS_BAR);
        if (newVis != oldVis) {
            view.setSystemUiVisibility(newVis);
        }
        return true;
    }

    private void setStatusBarColor(Window window, int color) {
        WindowManager.LayoutParams winParams = window.getAttributes();
        if (mStatusBarColorFiled != null) {
            try {
                int oldColor = mStatusBarColorFiled.getInt(winParams);
                if (oldColor != color) {
                    mStatusBarColorFiled.set(winParams, color);
                    window.setAttributes(winParams);
                }
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    private boolean changeMeizuFlag(WindowManager.LayoutParams winParams, String flagName, boolean on) {
        try {
            int meizuFlags;
            Field f = winParams.getClass().getDeclaredField(flagName);
            f.setAccessible(true);
            int bits = f.getInt(winParams);
            Field f2 = winParams.getClass().getDeclaredField("meizuFlags");
            f2.setAccessible(true);
            int oldFlags = meizuFlags = f2.getInt(winParams);
            meizuFlags = on ? (meizuFlags |= bits) : (meizuFlags &= ~bits);
            if (oldFlags != meizuFlags) {
                f2.setInt(winParams, meizuFlags);
                return true;
            }
        }
        catch (Exception e) {
            Log.e((String)"LightModeException", (String)"Failed to match Flyme");
        }
        return false;
    }

    static {
        SYSTEM_UI_FLAG_LIGHT_STATUS_BAR = 0;
    }
}

