/*
 * Decompiled with CFR 0.152.
 */
package spa.lyh.cn.statusbarlightmode;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.util.Log;
import android.view.View;
import android.widget.Toast;
import spa.lyh.cn.statusbarlightmode.ImmersionConfiguration;
import spa.lyh.cn.statusbarlightmode.helpers.immersionmode.ImmersionHelper;

public class ImmersionMode {
    private static String TAG = "ImmersionMode";
    private static ImmersionMode instance;
    private ImmersionConfiguration configuration;
    private ImmersionConfiguration temporaryConfig;
    private View starusView;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ImmersionMode getInstance() {
        if (instance != null) return instance;
        Class<ImmersionMode> clazz = ImmersionMode.class;
        synchronized (ImmersionMode.class) {
            if (instance != null) return instance;
            instance = new ImmersionMode();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public synchronized void init(ImmersionConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException("ImmersionMode configuration can not be initialized with null");
        }
        if (this.configuration == null) {
            Log.e((String)TAG, (String)"Initialize ImmersionMode with configuration");
            this.configuration = configuration;
        } else {
            Log.e((String)TAG, (String)"Try to initialize ImmersionMode which had already been initialized before. To re-init ImmersionMode with new configuration call ImmersionMode.destroy() at first.");
        }
    }

    public void setTemporaryConfig(ImmersionConfiguration config) {
        this.temporaryConfig = config;
    }

    public void destory() {
        if (this.configuration != null) {
            Log.e((String)TAG, (String)"Destroy configuration");
            this.configuration = null;
        }
    }

    public boolean execImmersionMode(Activity activity) {
        boolean mark = false;
        if (Build.VERSION.SDK_INT >= 19) {
            ImmersionConfiguration config = this.backupConfig(this.configuration);
            if (this.temporaryConfig != null) {
                this.setTemporaryConfiguration(this.temporaryConfig);
            }
            if (this.configuration.enable == ImmersionConfiguration.ENABLE) {
                this.starusView = ImmersionHelper.statusBarFitToAPP(activity, this.configuration.defaultColor);
                mark = true;
            }
            this.configuration = config;
            this.temporaryConfig = null;
        }
        return mark;
    }

    private ImmersionConfiguration backupConfig(ImmersionConfiguration configuration) {
        ImmersionConfiguration config = new ImmersionConfiguration.Builder(configuration.context).enableImmersionMode(configuration.enable).setIntColor(configuration.defaultColor).build();
        return config;
    }

    private void setTemporaryConfiguration(ImmersionConfiguration tConfig) {
        this.configuration.enable = tConfig.enable;
        this.configuration.defaultColor = tConfig.defaultColor;
    }

    public void setStarusViewGONE() {
        if (Build.VERSION.SDK_INT >= 19 && this.starusView != null) {
            this.starusView.setVisibility(8);
        }
    }

    public void setStarusViewVISIBLE() {
        if (Build.VERSION.SDK_INT >= 19 && this.starusView != null) {
            this.starusView.setVisibility(0);
        }
    }

    public void throwDisableERROR(Activity activity) {
        Log.e((String)TAG, (String)"Disable must called before 'setContentView()',or it will not work properly.");
        Toast.makeText((Context)activity, (CharSequence)"Disable must called before 'setContentView()',or it will not work properly.", (int)1).show();
    }
}

