/*
 * Decompiled with CFR 0.152.
 */
package spa.lyh.cn.statusbarlightmode;

import android.content.Context;
import android.graphics.Color;
import android.util.Log;

public class ImmersionConfiguration {
    private static String TAG = "ImmersionConfiguration";
    public static int ENABLE = 100;
    public static int DISABLE = 101;
    Context context;
    int enable;
    int defaultColor;

    private ImmersionConfiguration(Builder builder) {
        this.context = builder.context;
        this.enable = builder.enable;
        this.defaultColor = builder.defaultColor;
    }

    public static class Builder {
        Context context;
        int enable;
        int defaultColor;

        public Builder(Context context) {
            this.context = context;
        }

        public Builder enableImmersionMode(int enable) {
            this.enable = enable;
            return this;
        }

        public Builder setColor(String color) {
            try {
                this.defaultColor = Color.parseColor((String)color);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"Unknown defaultColor");
                this.defaultColor = Color.parseColor((String)"#D0D0D0");
            }
            return this;
        }

        public Builder setColor(int resID) {
            try {
                this.defaultColor = this.context.getResources().getColor(resID);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"Unknown defaultColor");
                this.defaultColor = Color.parseColor((String)"#D0D0D0");
            }
            return this;
        }

        public Builder setIntColor(int color) {
            this.defaultColor = color;
            return this;
        }

        public ImmersionConfiguration build() {
            this.initEmptyFieldsWithDefaultValues();
            return new ImmersionConfiguration(this);
        }

        private void initEmptyFieldsWithDefaultValues() {
            if (this.enable == 0) {
                this.enable = ENABLE;
            }
            if (this.defaultColor == 0) {
                this.defaultColor = Color.parseColor((String)"#D0D0D0");
            }
        }
    }
}

