/*
 * Decompiled with CFR 0.152.
 */
package spa.lyh.cn.statusbarlightmode.helpers.immersionmode;

import android.app.Activity;
import android.content.Context;
import android.graphics.Color;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import spa.lyh.cn.statusbarlightmode.barutils.barUtils;
import spa.lyh.cn.statusbarlightmode.helpers.lightmode.AndroidMHelper;
import spa.lyh.cn.statusbarlightmode.helpers.lightmode.FlymeHelper;
import spa.lyh.cn.statusbarlightmode.helpers.lightmode.MIUIHelper;

public class ImmersionHelper {
    public static View statusBarFitToAPP(Activity activity, int color) {
        int redValue = Color.red((int)color);
        int greenValue = Color.green((int)color);
        int blueValue = Color.blue((int)color);
        int[] colorArry = new int[]{redValue, greenValue, blueValue};
        View v = ImmersionHelper.changeStatusBarColor(activity, color);
        ImmersionHelper.setStatusBarMode(activity, barUtils.isLightRGB(colorArry));
        return v;
    }

    private static View changeStatusBarColor(Activity activity, int color) {
        if (Build.VERSION.SDK_INT >= 21) {
            Window window = activity.getWindow();
            window.setStatusBarColor(color);
        } else if (Build.VERSION.SDK_INT >= 19) {
            barUtils.transparencyBar(activity);
            ViewGroup vg = (ViewGroup)activity.getWindow().getDecorView();
            View v = new View((Context)activity);
            ViewGroup.LayoutParams params = new ViewGroup.LayoutParams(-1, barUtils.getStatusBarHeight((Context)activity));
            v.setBackgroundColor(color);
            v.setLayoutParams(params);
            vg.addView(v);
            return v;
        }
        return null;
    }

    private static boolean setStatusBarMode(Activity activity, boolean isLightMode) {
        boolean flag = false;
        if (new MIUIHelper().setLightMode(activity, isLightMode)) {
            flag = true;
        } else if (new FlymeHelper().setLightMode(activity, isLightMode)) {
            flag = true;
        } else if (new AndroidMHelper().setLightMode(activity, isLightMode)) {
            flag = true;
        }
        return flag;
    }
}

