/*
 * Decompiled with CFR 0.152.
 */
package sp.sd.nexusartifactuploader;

import com.google.common.base.Strings;
import hudson.model.TaskListener;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

public final class Utils {
    private Utils() {
    }

    public static Boolean uploadArtifact(File artifactFile, TaskListener Listener, String ResolvedNexusUser, String ResolvedNexusPassword, String ResolvedNexusUrl, String ResolvedGroupId, String ResolvedArtifactId, String ResolvedVersion, String ResolvedRepository, String ResolvedPackaging, String ResolvedProtocol) throws IOException {
        Boolean result = false;
        if (Strings.isNullOrEmpty((String)ResolvedNexusUrl)) {
            Listener.getLogger().println("Url of the Nexus is empty. Please enter Nexus Url.");
            return false;
        }
        try {
            URI Url = new URI(ResolvedProtocol + "://" + ResolvedNexusUrl + "/service/local/artifact/maven/content");
            HttpHost host = new HttpHost(Url.getHost(), Url.getPort(), Url.getScheme());
            BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
            credsProvider.setCredentials(new AuthScope(Url.getHost(), Url.getPort()), (Credentials)new UsernamePasswordCredentials(ResolvedNexusUser, ResolvedNexusPassword));
            BasicAuthCache authCache = new BasicAuthCache();
            BasicScheme basicAuth = new BasicScheme();
            authCache.put(host, (AuthScheme)basicAuth);
            HttpClientContext localContext = HttpClientContext.create();
            localContext.setAuthCache((AuthCache)authCache);
            CloseableHttpClient httpClient = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)credsProvider).build();
            HttpPost httpPost = new HttpPost(ResolvedProtocol + "://" + ResolvedNexusUrl + "/service/local/artifact/maven/content");
            Listener.getLogger().println("GroupId: " + ResolvedGroupId);
            Listener.getLogger().println("ArtifactId: " + ResolvedArtifactId);
            Listener.getLogger().println("Version: " + ResolvedVersion);
            Listener.getLogger().println("File: " + artifactFile.getName());
            Listener.getLogger().println("Repository:" + ResolvedRepository);
            Listener.getLogger().println("Uploading artifact " + artifactFile.getName() + " started....");
            FileBody artifactFileBody = new FileBody(artifactFile);
            HttpEntity requestEntity = MultipartEntityBuilder.create().addPart("r", (ContentBody)new StringBody(ResolvedRepository, ContentType.TEXT_PLAIN)).addPart("hasPom", (ContentBody)new StringBody("false", ContentType.TEXT_PLAIN)).addPart("e", (ContentBody)new StringBody(ResolvedPackaging, ContentType.TEXT_PLAIN)).addPart("g", (ContentBody)new StringBody(ResolvedGroupId, ContentType.TEXT_PLAIN)).addPart("a", (ContentBody)new StringBody(ResolvedArtifactId, ContentType.TEXT_PLAIN)).addPart("v", (ContentBody)new StringBody(ResolvedVersion, ContentType.TEXT_PLAIN)).addPart("p", (ContentBody)new StringBody(ResolvedPackaging, ContentType.TEXT_PLAIN)).addPart("file", (ContentBody)artifactFileBody).build();
            httpPost.setEntity(requestEntity);
            try (CloseableHttpResponse response = httpClient.execute(host, (HttpRequest)httpPost, (HttpContext)localContext);){
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode == 201) {
                    result = true;
                    Listener.getLogger().println("Uploading artifact " + artifactFile.getName() + " completed.");
                } else {
                    Listener.getLogger().println("Reason Phrase: " + response.getStatusLine().getReasonPhrase());
                    HttpEntity entity = response.getEntity();
                    String content = EntityUtils.toString((HttpEntity)entity);
                    Listener.getLogger().println(content);
                    result = false;
                }
            }
        }
        catch (URISyntaxException e) {
            Listener.getLogger().println(e.getMessage());
            result = false;
        }
        return result;
    }
}

