/*
 * Decompiled with CFR 0.152.
 */
package sp.sd.nexusartifactuploader;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernameListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.google.common.base.Strings;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.ProminentProjectAction;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import hudson.security.ACL;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import jenkins.MasterToSlaveFileCallable;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import org.acegisecurity.Authentication;
import org.jenkinsci.remoting.RoleChecker;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import sp.sd.nexusartifactuploader.Utils;

public class NexusArtifactUploader
extends Builder
implements SimpleBuildStep,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String protocol;
    private final String nexusUrl;
    private final String nexusUser;
    private final Secret nexusPassword;
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final String packaging;
    private final String repository;
    private final String file;
    @CheckForNull
    private final String credentialsId;

    @DataBoundConstructor
    public NexusArtifactUploader(String protocol, String nexusUrl, String nexusUser, Secret nexusPassword, String groupId, String artifactId, String version, String packaging, String repository, String file, String credentialsId) {
        this.protocol = protocol;
        this.nexusUrl = nexusUrl;
        this.nexusUser = nexusUser;
        this.nexusPassword = nexusPassword;
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.packaging = packaging;
        this.repository = repository;
        this.file = file;
        this.credentialsId = credentialsId;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getNexusUrl() {
        return this.nexusUrl;
    }

    public String getNexusUser() {
        return this.nexusUser;
    }

    public Secret getNexusPassword() {
        return this.nexusPassword;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getPackaging() {
        return this.packaging;
    }

    public String getRepository() {
        return this.repository;
    }

    public String getFile() {
        return this.file;
    }

    @Nullable
    public String getCredentialsId() {
        return this.credentialsId;
    }

    public StandardUsernameCredentials getCredentials() {
        StandardUsernameCredentials credentials = null;
        try {
            StandardUsernameCredentials standardUsernameCredentials = this.credentialsId == null ? null : (credentials = NexusArtifactUploader.lookupSystemCredentials(this.credentialsId));
            if (credentials != null) {
                return credentials;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return credentials;
    }

    public static StandardUsernameCredentials lookupSystemCredentials(String credentialsId) {
        return (StandardUsernameCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardUsernameCredentials.class, (ItemGroup)Jenkins.getInstance(), (Authentication)ACL.SYSTEM, Collections.emptyList()), (CredentialsMatcher)CredentialsMatchers.withId((String)credentialsId));
    }

    public String getUsername(EnvVars environment) {
        String Username = null;
        Username = Strings.isNullOrEmpty((String)this.nexusUser) ? "" : environment.expand(this.nexusUser);
        if (!Strings.isNullOrEmpty((String)this.credentialsId)) {
            Username = this.getCredentials().getUsername();
        }
        return Username;
    }

    public String getPassword(EnvVars environment) {
        String Password = null;
        Password = this.nexusPassword == null ? "" : environment.expand(Secret.toString((Secret)this.nexusPassword));
        if (!Strings.isNullOrEmpty((String)this.credentialsId)) {
            Password = Secret.toString((Secret)((StandardUsernamePasswordCredentials)StandardUsernamePasswordCredentials.class.cast(this.getCredentials())).getPassword());
        }
        return Password;
    }

    public void perform(Run build, FilePath workspace, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        boolean result = false;
        EnvVars envVars = build.getEnvironment(listener);
        FilePath artifactFilePath = new FilePath(workspace, build.getEnvironment(listener).expand(this.file));
        if (!artifactFilePath.exists()) {
            listener.getLogger().println(artifactFilePath.getName() + " file doesn't exists");
            throw new IOException(artifactFilePath.getName() + " file doesn't exists");
        }
        result = (Boolean)artifactFilePath.act((FilePath.FileCallable)new ArtifactFileCallable(listener, this.getUsername(envVars), this.getPassword(envVars), envVars.expand(this.nexusUrl), envVars.expand(this.groupId), envVars.expand(this.artifactId), envVars.expand(this.version), envVars.expand(this.repository), envVars.expand(this.packaging), this.protocol));
        if (!result) {
            build.setResult(Result.FAILURE);
        }
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension
    public static final class DescriptorImpl<C extends StandardCredentials>
    extends BuildStepDescriptor<Builder> {
        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "Upload artifact to nexus";
        }

        public FormValidation doCheckNexusUrl(@QueryParameter String value) {
            if (value.length() == 0) {
                return FormValidation.error((String)"URL must not be empty");
            }
            if (value.startsWith("http://") || value.startsWith("https://")) {
                return FormValidation.error((String)"URL must not start with http:// or https://");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckGroupId(@QueryParameter String value) {
            if (value.length() == 0) {
                return FormValidation.error((String)"GroupId must not be empty");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckArtifactId(@QueryParameter String value) {
            if (value.length() == 0) {
                return FormValidation.error((String)"ArtifactId must not be empty");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckVersion(@QueryParameter String value) {
            if (value.length() == 0) {
                return FormValidation.error((String)"Version must not be empty");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckPackaging(@QueryParameter String value) {
            if (value.length() == 0) {
                return FormValidation.error((String)"Packaging must not be empty");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckRepository(@QueryParameter String value) {
            if (value.length() == 0) {
                return FormValidation.error((String)"Repository must not be empty");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckFile(@QueryParameter String value) {
            if (value.length() == 0) {
                return FormValidation.error((String)"File must not be empty");
            }
            return FormValidation.ok();
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item owner) {
            if (owner == null || !owner.hasPermission(Item.CONFIGURE)) {
                return new ListBoxModel();
            }
            return new StandardUsernameListBoxModel().withEmptySelection().withAll((Iterable)CredentialsProvider.lookupCredentials(StandardUsernamePasswordCredentials.class, (Item)owner, (Authentication)ACL.SYSTEM, Collections.emptyList()));
        }
    }

    public static final class LinkAction
    implements Action,
    ProminentProjectAction {
        private final String name;
        private final String url;
        private final String icon;

        public LinkAction(String ResolvedNexusUrl, String ResolvedGroupId, String ResolvedArtifactId, String ResolvedVersion, String ResolvedRepository, String ResolvedPackaging, String ResolvedProtocol, String Name) {
            this.name = Name;
            this.url = ResolvedProtocol + "://" + ResolvedNexusUrl + "/service/local/repositories/" + ResolvedRepository + "/content/" + ResolvedGroupId.replace('.', '/') + "/" + ResolvedArtifactId + "/" + ResolvedVersion + "/" + ResolvedArtifactId + "-" + ResolvedVersion + "." + ResolvedPackaging;
            this.icon = "package.gif";
        }

        public String getIconFileName() {
            return this.icon;
        }

        public String getDisplayName() {
            return this.name;
        }

        public String getUrlName() {
            return this.url;
        }
    }

    private static final class ArtifactFileCallable
    extends MasterToSlaveFileCallable<Boolean> {
        private final TaskListener listener;
        private final String resolvedNexusUser;
        private final String resolvedNexusPassword;
        private final String resolvedNexusUrl;
        private final String resolvedGroupId;
        private final String resolvedArtifactId;
        private final String resolvedVersion;
        private final String resolvedRepository;
        private final String resolvedPackaging;
        private final String resolvedProtocol;

        public ArtifactFileCallable(TaskListener Listener, String ResolvedNexusUser, String ResolvedNexusPassword, String ResolvedNexusUrl, String ResolvedGroupId, String ResolvedArtifactId, String ResolvedVersion, String ResolvedRepository, String ResolvedPackaging, String ResolvedProtocol) {
            this.listener = Listener;
            this.resolvedNexusUser = ResolvedNexusUser;
            this.resolvedNexusPassword = ResolvedNexusPassword;
            this.resolvedNexusUrl = ResolvedNexusUrl;
            this.resolvedGroupId = ResolvedGroupId;
            this.resolvedArtifactId = ResolvedArtifactId;
            this.resolvedVersion = ResolvedVersion;
            this.resolvedRepository = ResolvedRepository;
            this.resolvedPackaging = ResolvedPackaging;
            this.resolvedProtocol = ResolvedProtocol;
        }

        public Boolean invoke(File artifactFile, VirtualChannel channel) throws IOException {
            return Utils.uploadArtifact(artifactFile, this.listener, this.resolvedNexusUser, this.resolvedNexusPassword, this.resolvedNexusUrl, this.resolvedGroupId, this.resolvedArtifactId, this.resolvedVersion, this.resolvedRepository, this.resolvedPackaging, this.resolvedProtocol);
        }

        public void checkRoles(RoleChecker checker) throws SecurityException {
        }
    }
}

