/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.vaadin.grid_exporter.wizard.steps;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.html.HtmlObject;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.server.AbstractStreamResource;
import com.vaadin.flow.server.InputStreamFactory;
import com.vaadin.flow.server.StreamResource;
import com.vaadin.flow.shared.Registration;
import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.util.Objects;
import software.xdev.vaadin.grid_exporter.Translator;
import software.xdev.vaadin.grid_exporter.format.Format;
import software.xdev.vaadin.grid_exporter.wizard.GridExporterWizardState;
import software.xdev.vaadin.grid_exporter.wizard.steps.AbstractGridExportWizardStepComposite;

public class PreviewStep<T>
extends AbstractGridExportWizardStepComposite<VerticalLayout, T> {
    protected HtmlObject resViewer = new HtmlObject();

    public PreviewStep(Translator translator) {
        super(translator);
        this.setStepName(this.translate("gridexporter.preview"));
        this.initUI();
    }

    protected void initUI() {
        this.resViewer.getStyle().set("text-align", "center");
        this.resViewer.getElement().setText(this.translate("gridexporter.unable_to_show_preview"));
        this.resViewer.setSizeFull();
        ((VerticalLayout)this.getContent()).add(new Component[]{this.resViewer});
        ((VerticalLayout)this.getContent()).setPadding(false);
        ((VerticalLayout)this.getContent()).setSizeFull();
    }

    @Override
    public void onEnterStep(GridExporterWizardState<T> state) {
        Format format = state.getSelectedFormat();
        byte[] bytes = format.export(state.getGridDataExtractor(), state.getSelectedColumns(), state.getSpecificConfigs());
        StreamResource resource = new StreamResource(state.getFileName() + "." + format.getFormatFilenameSuffix(), (InputStreamFactory & Serializable)() -> new ByteArrayInputStream(bytes));
        resource.setContentType(format.getMimeType());
        this.resViewer.setType(format.getMimeType());
        this.resViewer.setData((AbstractStreamResource)resource);
        this.fireEvent(new StreamResourceGeneratedEvent(resource, this, false));
    }

    public Registration addStreamResourceGeneratedListener(ComponentEventListener<StreamResourceGeneratedEvent<T>> listener) {
        return this.addListener(StreamResourceGeneratedEvent.class, listener);
    }

    public static class StreamResourceGeneratedEvent<T>
    extends ComponentEvent<PreviewStep<T>> {
        protected final StreamResource resource;

        public StreamResourceGeneratedEvent(StreamResource resource, PreviewStep<T> source, boolean fromClient) {
            super(source, fromClient);
            this.resource = Objects.requireNonNull(resource);
        }

        public StreamResource getResource() {
            return this.resource;
        }
    }
}

