/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.vaadin.grid_exporter.wizard;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import software.xdev.vaadin.grid_exporter.column.ColumnConfiguration;
import software.xdev.vaadin.grid_exporter.components.wizard.WizardState;
import software.xdev.vaadin.grid_exporter.format.Format;
import software.xdev.vaadin.grid_exporter.format.SpecificConfig;
import software.xdev.vaadin.grid_exporter.grid.GridDataExtractor;

public class GridExporterWizardState<T>
implements WizardState {
    protected final GridDataExtractor<T> gridDataExtractor;
    protected final List<Format> availableFormats;
    protected final List<ColumnConfiguration<T>> availableColumns;
    protected String fileName = "";
    protected List<ColumnConfiguration<T>> selectedColumns;
    protected Format selectedFormat = null;
    protected final List<SpecificConfig> specificConfigs = new ArrayList<SpecificConfig>();

    public GridExporterWizardState(GridDataExtractor<T> gridDataExtractor, List<Format> availableFormats, List<ColumnConfiguration<T>> availableColumns) {
        this.gridDataExtractor = Objects.requireNonNull(gridDataExtractor);
        this.availableFormats = Objects.requireNonNull(availableFormats);
        this.availableColumns = Objects.requireNonNull(availableColumns);
        this.selectedColumns = availableColumns.stream().filter(col -> !col.getHeader().isBlank()).collect(Collectors.toList());
    }

    public GridDataExtractor<T> getGridDataExtractor() {
        return this.gridDataExtractor;
    }

    public List<Format> getAvailableFormats() {
        return this.availableFormats;
    }

    public List<ColumnConfiguration<T>> getAvailableColumns() {
        return this.availableColumns;
    }

    public List<ColumnConfiguration<T>> getSelectedColumns() {
        return this.selectedColumns;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = Objects.requireNonNull(fileName);
    }

    public void setSelectedColumns(List<ColumnConfiguration<T>> selectedColumns) {
        this.selectedColumns = Objects.requireNonNull(selectedColumns);
    }

    public Format getSelectedFormat() {
        return this.selectedFormat;
    }

    public void setSelectedFormat(Format selectedFormat) {
        this.selectedFormat = selectedFormat;
    }

    public List<SpecificConfig> getSpecificConfigs() {
        return this.specificConfigs;
    }
}

