/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.vaadin.grid_exporter.jasper.config.page;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.formlayout.FormLayout;
import com.vaadin.flow.component.textfield.IntegerField;
import java.io.Serializable;
import software.xdev.dynamicreports.report.constant.PageOrientation;
import software.xdev.dynamicreports.report.constant.PageType;
import software.xdev.vaadin.grid_exporter.Translator;
import software.xdev.vaadin.grid_exporter.format.SpecificConfigComponent;
import software.xdev.vaadin.grid_exporter.jasper.config.page.PageConfig;

public class PageConfigComponent
extends SpecificConfigComponent<PageConfig> {
    protected final ComboBox<PageType> cbPageType = new ComboBox();
    protected final ComboBox<PageOrientation> cbPageOrientation = new ComboBox();
    protected final Checkbox chbxPageNumbering = new Checkbox();
    protected final IntegerField intfPageMargin = new IntegerField();

    public PageConfigComponent(Translator translator) {
        super(translator, PageConfig::new, "gridexporter.jasperformats.page");
        this.initUIs();
        this.registerBindings();
    }

    protected void initUIs() {
        this.cbPageType.setLabel(this.translate("gridexporter.jasperformats.format_page_type"));
        this.cbPageType.setItemLabelGenerator(Enum::name);
        this.cbPageOrientation.setLabel(this.translate("gridexporter.jasperformats.orientation"));
        this.cbPageOrientation.setItemLabelGenerator((ItemLabelGenerator & Serializable)po -> this.translate("gridexporter.jasperformats.orientation." + po.name().toLowerCase()));
        this.chbxPageNumbering.setLabel(this.translate("gridexporter.jasperformats.show_page_numbers"));
        this.intfPageMargin.setLabel(this.translate("gridexporter.jasperformats.margin"));
        this.intfPageMargin.setStepButtonsVisible(true);
        this.intfPageMargin.setMin(0);
        this.intfPageMargin.setMax(1000);
        ((FormLayout)this.getContent()).add(new Component[]{this.cbPageType, this.cbPageOrientation, this.chbxPageNumbering, this.intfPageMargin});
    }

    protected void registerBindings() {
        this.binder.forField(this.cbPageType).asRequired().bind(PageConfig::getSelectedPageType, PageConfig::setSelectedPageType);
        this.binder.forField(this.cbPageOrientation).asRequired().bind(PageConfig::getSelectedPageOrientation, PageConfig::setSelectedPageOrientation);
        this.binder.forField((HasValue)this.chbxPageNumbering).bind(PageConfig::isUsePageNumbering, PageConfig::setUsePageNumbering);
        this.binder.forField((HasValue)this.intfPageMargin).asRequired().bind(PageConfig::getPageMargin, PageConfig::setPageMargin);
    }

    @Override
    public void updateFrom(PageConfig value) {
        this.cbPageType.setItems(value.getAvailablePageTypes());
        this.cbPageOrientation.setItems(value.getAvailablePageOrientations());
        super.updateFrom(value);
    }
}

