/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.vaadin.grid_exporter.format;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import software.xdev.vaadin.grid_exporter.Translator;
import software.xdev.vaadin.grid_exporter.format.Format;
import software.xdev.vaadin.grid_exporter.format.SpecificConfig;
import software.xdev.vaadin.grid_exporter.format.SpecificConfigComponent;

public abstract class AbstractFormat
implements Format {
    protected final String nameToDisplay;
    protected final String fileSuffix;
    protected final String mimeType;
    protected List<Function<Translator, ? extends SpecificConfigComponent<? extends SpecificConfig>>> configComponents = new ArrayList<Function<Translator, ? extends SpecificConfigComponent<? extends SpecificConfig>>>();

    protected AbstractFormat(String nameToDisplay, String fileSuffix, String mimeType) {
        this.nameToDisplay = Objects.requireNonNull(nameToDisplay);
        this.fileSuffix = Objects.requireNonNull(fileSuffix);
        this.mimeType = Objects.requireNonNull(mimeType);
    }

    @SafeVarargs
    public final void withConfigComponents(Function<Translator, ? extends SpecificConfigComponent<? extends SpecificConfig>> ... configComponents) {
        this.configComponents.addAll(Arrays.asList(configComponents));
    }

    @Override
    public String getFormatNameToDisplay() {
        return this.nameToDisplay;
    }

    @Override
    public String getFormatFilenameSuffix() {
        return this.fileSuffix;
    }

    @Override
    public String getMimeType() {
        return this.mimeType;
    }

    @Override
    public List<Function<Translator, ? extends SpecificConfigComponent<? extends SpecificConfig>>> getConfigComponents() {
        return this.configComponents;
    }

    protected <C extends SpecificConfig> Optional<C> getConfigFrom(List<? extends SpecificConfig> configs, Class<C> targetedConfigClass) {
        return configs.stream().filter(targetedConfigClass::isInstance).map(targetedConfigClass::cast).findFirst();
    }

    protected <V, C extends SpecificConfig> Optional<V> getValueFrom(List<? extends SpecificConfig> configs, Class<C> targetedConfigClass, Function<C, V> mapper) {
        return this.getConfigFrom(configs, targetedConfigClass).stream().findFirst().map(mapper);
    }
}

