/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.vaadin.grid_exporter.components.wizard.panel;

import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.Composite;
import com.vaadin.flow.component.HasEnabled;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.progressbar.ProgressBar;
import com.vaadin.flow.component.tabs.Tab;
import com.vaadin.flow.component.tabs.Tabs;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import software.xdev.vaadin.grid_exporter.components.wizard.WizardState;
import software.xdev.vaadin.grid_exporter.components.wizard.panel.WizardPanelActions;
import software.xdev.vaadin.grid_exporter.components.wizard.step.WizardPanelStepChangedEvent;
import software.xdev.vaadin.grid_exporter.components.wizard.step.WizardStep;
import software.xdev.vaadin.grid_exporter.components.wizard.step.WizardStepState;

@CssImport(value="./styles/wizard.css")
public class WizardPanel<S extends WizardState>
extends Composite<VerticalLayout>
implements WizardPanelActions {
    protected int stepIndex = -1;
    protected final List<Component> lstSteps = new ArrayList<Component>();
    protected final Map<Tab, Component> tabStepMap = new HashMap<Tab, Component>();
    protected S curState = null;
    protected final Tabs tabsStep = new Tabs();
    protected final ProgressBar progress = new ProgressBar();
    protected final VerticalLayout vlContent = new VerticalLayout();

    public WizardPanel() {
        this.initUI();
    }

    protected void initUI() {
        this.tabsStep.addClassName("wizard-panel-tabs");
        this.tabsStep.setAutoselect(false);
        this.tabsStep.addSelectedChangeListener(this::onTabChange);
        this.progress.setHeight("0.2em");
        this.progress.setMinHeight(this.progress.getHeight());
        this.progress.getStyle().set("margin-top", "0");
        this.vlContent.addClassName("wizard-panel-content");
        this.vlContent.getStyle().set("overflow-y", "auto");
        this.vlContent.setPadding(false);
        VerticalLayout vlRoot = (VerticalLayout)this.getContent();
        vlRoot.addClassName("wizard-panel");
        vlRoot.setPadding(false);
        vlRoot.setSpacing(false);
        vlRoot.setAlignItems(FlexComponent.Alignment.STRETCH);
        vlRoot.add(new Component[]{this.tabsStep});
        vlRoot.add(new Component[]{this.progress});
        vlRoot.addAndExpand(new Component[]{this.vlContent});
    }

    protected void onAttach(AttachEvent attachEvent) {
        if (!this.lstSteps.isEmpty()) {
            this.showFirstStep(attachEvent.isFromClient());
        }
    }

    protected void onTabChange(Tabs.SelectedChangeEvent event) {
        Tab selTab = event.getSelectedTab();
        Component tabPage = this.tabStepMap.get(selTab);
        this.stepIndex = this.lstSteps.indexOf(tabPage);
        this.vlContent.removeAll();
        this.vlContent.add(new Component[]{tabPage});
        this.updateProgress();
    }

    public <T extends Component> void addStep(T step) {
        Objects.requireNonNull(step);
        Tab tab = new Tab(((WizardStep)step).getStepName());
        tab.setFlexGrow(1.0);
        tab.setEnabled(false);
        this.tabStepMap.put(tab, step);
        this.lstSteps.add(step);
        this.tabsStep.add(new Tab[]{tab});
    }

    public S getState() {
        return this.curState;
    }

    public void setState(S state) {
        this.curState = state;
        this.lstSteps.forEach(step -> ((WizardStep)step).setWizardState(state));
    }

    protected void updateProgress() {
        int curStep = this.stepIndex + 1;
        int stepCount = this.lstSteps.size();
        this.progress.setValue(stepCount == 0 ? 1.0 : (double)curStep / (double)stepCount);
    }

    @Override
    public void showFirstStep(boolean isFromClient) {
        this.showStep(0, isFromClient);
    }

    @Override
    public void showPreviousStep(boolean isFromClient) {
        this.showStep(this.stepIndex - 1, isFromClient);
    }

    @Override
    public void showNextStep(boolean isFromClient) {
        WizardStep curStep = (WizardStep)this.lstSteps.get(this.stepIndex);
        if (!curStep.onProgress(this.curState)) {
            return;
        }
        if (this.lstSteps.isEmpty() || this.stepIndex == this.lstSteps.size() - 1) {
            return;
        }
        if (this.stepIndex >= 0 && this.stepIndex < this.lstSteps.size() - 1) {
            int nextStepIndex = this.stepIndex + 1;
            this.showStep(nextStepIndex, isFromClient);
        }
    }

    protected void showStep(int stepIndex, boolean isFromClient) {
        if (stepIndex < 0 || stepIndex >= this.lstSteps.size() || this.stepIndex == stepIndex) {
            return;
        }
        this.enableTab(this.stepIndex, false);
        this.enableTab(stepIndex, true);
        this.stepIndex = stepIndex;
        this.tabsStep.setSelectedIndex(stepIndex);
        WizardStep newStep = (WizardStep)this.lstSteps.get(stepIndex);
        newStep.onEnterStep(this.curState);
        this.updateProgress();
        this.fireEvent(new WizardPanelStepChangedEvent(new WizardStepState(this.stepIndex + 1, this.lstSteps.size()), this, isFromClient));
    }

    protected void enableTab(int stepIndex, boolean enable) {
        if (stepIndex < 0 || stepIndex >= this.tabsStep.getComponentCount()) {
            return;
        }
        Component tab = this.tabsStep.getComponentAt(stepIndex);
        if (tab instanceof HasEnabled) {
            ((HasEnabled)tab).setEnabled(enable);
        }
    }

    @Override
    public void addStepStateChangedListener(Consumer<WizardStepState> newStateConsumer) {
        this.addListener(WizardPanelStepChangedEvent.class, (ComponentEventListener & Serializable)ev -> newStateConsumer.accept(ev.getStepState()));
    }
}

