/*
 * Copyright © 2022 XDEV Software (https://xdev.software)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package software.xdev.vaadin.grid_exporter.jasper.format;

import software.xdev.dynamicreports.jasper.builder.JasperReportBuilder;
import software.xdev.dynamicreports.jasper.builder.export.Exporters;
import software.xdev.dynamicreports.jasper.builder.export.JasperRtfExporterBuilder;
import software.xdev.vaadin.grid_exporter.jasper.config.header.HeaderConfigComponent;
import software.xdev.vaadin.grid_exporter.jasper.config.page.PageConfigComponent;
import software.xdev.vaadin.grid_exporter.jasper.config.title.TitleConfigComponent;


public class RtfFormat extends AbstractJasperReportFormat<JasperRtfExporterBuilder>
{
	public RtfFormat()
	{
		super(
			"Rich Text",
			"rtf",
			"text/rtf",
			true,
			false,
			JasperReportBuilder::toRtf,
			Exporters::rtfExporter
		);
		this.withConfigComponents(
			TitleConfigComponent::new,
			// Don't export header by default because it's centered?
			translator -> new HeaderConfigComponent(translator, false),
			PageConfigComponent::new
		);
	}
}
