/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.serialization.java;

import java.util.List;
import java.util.stream.Collectors;
import software.xdev.mockserver.model.Cookies;
import software.xdev.mockserver.model.Headers;
import software.xdev.mockserver.model.HttpResponseModifier;
import software.xdev.mockserver.model.ObjectWithJsonToString;
import software.xdev.mockserver.serialization.java.CookieToJavaSerializer;
import software.xdev.mockserver.serialization.java.HeaderToJavaSerializer;
import software.xdev.mockserver.serialization.java.MultiValueToJavaSerializer;
import software.xdev.mockserver.serialization.java.ToJavaSerializer;

public class HttpResponseModifierToJavaSerializer
implements ToJavaSerializer<HttpResponseModifier> {
    public String serialize(List<HttpResponseModifier> httpResponseModifiers) {
        StringBuilder output = new StringBuilder();
        for (HttpResponseModifier httpResponseModifier : httpResponseModifiers) {
            output.append(this.serialize(0, httpResponseModifier)).append(';').append("\n");
        }
        return output.toString();
    }

    @Override
    public String serialize(int numberOfSpacesToIndent, HttpResponseModifier response) {
        StringBuilder output = new StringBuilder(18);
        if (response != null) {
            this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output);
            output.append("responseModifier()");
            if (response.getHeaders() != null) {
                this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output).append(".withHeaders(");
                this.outputHeaders(numberOfSpacesToIndent, output, (Headers)response.getHeaders().getAdd());
                this.outputHeaders(numberOfSpacesToIndent, output, (Headers)response.getHeaders().getReplace());
                this.outputList(numberOfSpacesToIndent, output, response.getHeaders().getRemove());
                this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output).append(')');
            }
            if (response.getCookies() != null) {
                this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output).append(".withCookies(");
                this.outputCookies(numberOfSpacesToIndent, output, (Cookies)response.getCookies().getAdd());
                this.outputCookies(numberOfSpacesToIndent, output, (Cookies)response.getCookies().getReplace());
                this.outputList(numberOfSpacesToIndent, output, response.getCookies().getRemove());
                this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output).append(')');
            }
        }
        return output.toString();
    }

    private void outputHeaders(int numberOfSpacesToIndent, StringBuilder output, Headers headers) {
        if (headers != null && !headers.isEmpty()) {
            this.appendNewLineAndIndent((numberOfSpacesToIndent + 2) * 8, output).append("headers(");
            this.appendObject(numberOfSpacesToIndent + 2, output, new HeaderToJavaSerializer(), headers.getEntries());
            this.appendNewLineAndIndent((numberOfSpacesToIndent + 2) * 8, output).append("),");
        } else {
            this.appendNewLineAndIndent((numberOfSpacesToIndent + 2) * 8, output).append("null,");
        }
    }

    private void outputCookies(int numberOfSpacesToIndent, StringBuilder output, Cookies cookies) {
        if (cookies != null && !cookies.isEmpty()) {
            this.appendNewLineAndIndent((numberOfSpacesToIndent + 2) * 8, output).append("cookies(");
            this.appendObject(numberOfSpacesToIndent + 2, output, new CookieToJavaSerializer(), cookies.getEntries());
            this.appendNewLineAndIndent((numberOfSpacesToIndent + 2) * 8, output).append("),");
        } else {
            this.appendNewLineAndIndent((numberOfSpacesToIndent + 2) * 8, output).append("null,");
        }
    }

    private void outputList(int numberOfSpacesToIndent, StringBuilder output, List<String> add) {
        if (add != null && !add.isEmpty()) {
            this.appendNewLineAndIndent((numberOfSpacesToIndent + 2) * 8, output).append("List.of(").append(add.stream().map(s -> "\"" + s + "\"").collect(Collectors.joining(","))).append(')');
        } else {
            this.appendNewLineAndIndent((numberOfSpacesToIndent + 2) * 8, output).append("null");
        }
    }

    private <T extends ObjectWithJsonToString> void appendObject(int numberOfSpacesToIndent, StringBuilder output, MultiValueToJavaSerializer<T> toJavaSerializer, List<T> objects) {
        output.append(toJavaSerializer.serializeAsJava(numberOfSpacesToIndent + 1, objects));
    }

    private StringBuilder appendNewLineAndIndent(int numberOfSpacesToIndent, StringBuilder output) {
        return output.append("\n").append(" ".repeat(numberOfSpacesToIndent));
    }
}

