/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.mock.action.http;

import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.xdev.mockserver.closurecallback.websocketregistry.LocalCallbackRegistry;
import software.xdev.mockserver.closurecallback.websocketregistry.WebSocketClientRegistry;
import software.xdev.mockserver.closurecallback.websocketregistry.WebSocketRequestCallback;
import software.xdev.mockserver.httpclient.NettyHttpClient;
import software.xdev.mockserver.mock.HttpState;
import software.xdev.mockserver.mock.action.ExpectationForwardAndResponseCallback;
import software.xdev.mockserver.mock.action.ExpectationForwardCallback;
import software.xdev.mockserver.mock.action.http.HttpActionHandler;
import software.xdev.mockserver.mock.action.http.HttpForwardAction;
import software.xdev.mockserver.mock.action.http.HttpForwardActionResult;
import software.xdev.mockserver.model.Action;
import software.xdev.mockserver.model.HttpObjectCallback;
import software.xdev.mockserver.model.HttpRequest;
import software.xdev.mockserver.model.HttpRequestAndHttpResponse;
import software.xdev.mockserver.model.HttpResponse;
import software.xdev.mockserver.responsewriter.ResponseWriter;
import software.xdev.mockserver.uuid.UUIDService;

public class HttpForwardObjectCallbackActionHandler
extends HttpForwardAction {
    private static final Logger LOG = LoggerFactory.getLogger(HttpForwardObjectCallbackActionHandler.class);
    private final WebSocketClientRegistry webSocketClientRegistry;

    public HttpForwardObjectCallbackActionHandler(HttpState httpStateHandler, NettyHttpClient httpClient) {
        super(httpClient);
        this.webSocketClientRegistry = httpStateHandler.getWebSocketClientRegistry();
    }

    public void handle(HttpActionHandler actionHandler, HttpObjectCallback httpObjectCallback, HttpRequest request, ResponseWriter responseWriter, boolean synchronous, Runnable expectationPostProcessor) {
        String clientId = httpObjectCallback.getClientId();
        if (LocalCallbackRegistry.forwardClientExists((String)clientId)) {
            this.handleLocally(actionHandler, httpObjectCallback, request, responseWriter, synchronous, clientId);
        } else {
            this.handleViaWebSocket(actionHandler, httpObjectCallback, request, responseWriter, synchronous, expectationPostProcessor, clientId);
        }
    }

    private void handleLocally(HttpActionHandler actionHandler, HttpObjectCallback httpObjectCallback, HttpRequest request, ResponseWriter responseWriter, boolean synchronous, String clientId) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Locally sending request {} to client {}", (Object)request, (Object)clientId);
        }
        ExpectationForwardCallback expectationForwardCallback = LocalCallbackRegistry.retrieveForwardCallback((String)clientId);
        try {
            HttpRequest callbackRequest = expectationForwardCallback.handle(request);
            HttpForwardActionResult responseFuture = this.sendRequest(callbackRequest, null, null);
            ExpectationForwardAndResponseCallback expectationForwardAndResponseCallback = LocalCallbackRegistry.retrieveForwardAndResponseCallback((String)clientId);
            if (expectationForwardAndResponseCallback != null) {
                actionHandler.executeAfterForwardActionResponse(responseFuture, (httpResponse, exception) -> {
                    if (httpResponse != null) {
                        try {
                            HttpResponse callbackResponse = expectationForwardAndResponseCallback.handle(callbackRequest, httpResponse);
                            actionHandler.writeForwardActionResponse(callbackResponse, responseWriter, request, (Action)httpObjectCallback);
                        }
                        catch (Exception ex2) {
                            if (LOG.isWarnEnabled()) {
                                LOG.warn("Returning {} because client {} response callback threw an exception", new Object[]{HttpResponse.notFoundResponse(), clientId, ex2});
                            }
                            actionHandler.writeForwardActionResponse(this.notFoundFuture(request), responseWriter, request, (Action)httpObjectCallback, synchronous);
                        }
                    } else if (exception != null) {
                        actionHandler.handleExceptionDuringForwardingRequest((Action)httpObjectCallback, request, responseWriter, (Throwable)exception);
                    }
                }, synchronous);
            } else {
                actionHandler.writeForwardActionResponse(responseFuture, responseWriter, request, (Action)httpObjectCallback, synchronous);
            }
        }
        catch (Exception ex) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("Returning {} because client {} request callback throw an exception", new Object[]{HttpResponse.notFoundResponse(), clientId, ex});
            }
            actionHandler.writeForwardActionResponse(this.notFoundFuture(request), responseWriter, request, (Action)httpObjectCallback, synchronous);
        }
    }

    private void handleViaWebSocket(final HttpActionHandler actionHandler, final HttpObjectCallback httpObjectCallback, final HttpRequest request, final ResponseWriter responseWriter, final boolean synchronous, final Runnable expectationPostProcessor, final String clientId) {
        final String webSocketCorrelationId = UUIDService.getUUID();
        this.webSocketClientRegistry.registerForwardCallbackHandler(webSocketCorrelationId, new WebSocketRequestCallback(){

            public void handle(HttpRequest callbackRequest) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Received request over websocket {} from client {} for correlationId {}", new Object[]{callbackRequest, clientId, webSocketCorrelationId});
                }
                HttpForwardActionResult responseFuture = HttpForwardObjectCallbackActionHandler.this.sendRequest(callbackRequest.removeHeader("WebSocketCorrelationId"), null, null);
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Received response for request {} from client {}", (Object)callbackRequest, (Object)clientId);
                }
                HttpForwardObjectCallbackActionHandler.this.webSocketClientRegistry.unregisterForwardCallbackHandler(webSocketCorrelationId);
                if (expectationPostProcessor != null && BooleanUtils.isFalse((Boolean)httpObjectCallback.getResponseCallback())) {
                    expectationPostProcessor.run();
                }
                if (BooleanUtils.isTrue((Boolean)httpObjectCallback.getResponseCallback())) {
                    HttpForwardObjectCallbackActionHandler.this.handleResponseViaWebSocket(callbackRequest, responseFuture, actionHandler, webSocketCorrelationId, clientId, expectationPostProcessor, responseWriter, httpObjectCallback, synchronous);
                } else {
                    actionHandler.writeForwardActionResponse(responseFuture, responseWriter, callbackRequest, (Action)httpObjectCallback, synchronous);
                }
            }

            public void handleError(HttpResponse httpResponse) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Error sending request over websocket for client {} for correlationId {}", (Object)clientId, (Object)webSocketCorrelationId);
                }
                HttpForwardObjectCallbackActionHandler.this.webSocketClientRegistry.unregisterForwardCallbackHandler(webSocketCorrelationId);
                actionHandler.writeResponseActionResponse(httpResponse, responseWriter, request, (Action)httpObjectCallback, synchronous);
            }
        });
        if (!this.webSocketClientRegistry.sendClientMessage(clientId, request.clone().withHeader("WebSocketCorrelationId", new String[]{webSocketCorrelationId}), null)) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("Returning {} because client {} has closed web socket connection", (Object)HttpResponse.notFoundResponse(), (Object)clientId);
            }
            actionHandler.writeForwardActionResponse(this.notFoundFuture(request), responseWriter, request, (Action)httpObjectCallback, synchronous);
        } else if (LOG.isTraceEnabled()) {
            LOG.trace("Sending request over websocket {} to client {} for correlationId {}", new Object[]{request, clientId, webSocketCorrelationId});
        }
    }

    private void handleResponseViaWebSocket(HttpRequest request, HttpForwardActionResult responseFuture, HttpActionHandler actionHandler, String webSocketCorrelationId, String clientId, Runnable expectationPostProcessor, ResponseWriter responseWriter, HttpObjectCallback httpObjectCallback, boolean synchronous) {
        actionHandler.executeAfterForwardActionResponse(responseFuture, (httpResponse, exception) -> {
            if (httpResponse != null) {
                CompletableFuture<HttpResponse> httpResponseCompletableFuture = new CompletableFuture<HttpResponse>();
                this.webSocketClientRegistry.registerResponseCallbackHandler(webSocketCorrelationId, overriddenResponse -> {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Received response over websocket {} for request and response {} from client {} for correlationId {}", new Object[]{overriddenResponse, new HttpRequestAndHttpResponse().withHttpRequest(request).withHttpResponse(httpResponse), clientId, webSocketCorrelationId});
                    }
                    this.webSocketClientRegistry.unregisterResponseCallbackHandler(webSocketCorrelationId);
                    if (expectationPostProcessor != null) {
                        expectationPostProcessor.run();
                    }
                    httpResponseCompletableFuture.complete(overriddenResponse.removeHeader("WebSocketCorrelationId"));
                });
                if (!this.webSocketClientRegistry.sendClientMessage(clientId, request.clone().withHeader("WebSocketCorrelationId", new String[]{webSocketCorrelationId}), httpResponse)) {
                    if (LOG.isWarnEnabled()) {
                        LOG.warn("Returning {} because client {} has closed web socket connection", (Object)HttpResponse.notFoundResponse(), (Object)clientId);
                    }
                    actionHandler.writeForwardActionResponse(this.notFoundFuture(request), responseWriter, request, (Action)httpObjectCallback, synchronous);
                } else if (LOG.isTraceEnabled()) {
                    LOG.trace("Sending request over websocket {} to client {} for correlationId {}", new Object[]{request, clientId, webSocketCorrelationId});
                }
                actionHandler.writeForwardActionResponse(responseFuture.setHttpResponse(httpResponseCompletableFuture), responseWriter, request, (Action)httpObjectCallback, synchronous);
            } else if (exception != null) {
                actionHandler.handleExceptionDuringForwardingRequest((Action)httpObjectCallback, request, responseWriter, (Throwable)exception);
            }
        }, synchronous);
    }
}

