/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.serialization.serializers.string;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import software.xdev.mockserver.model.NottableString;

public class NottableStringSerializer
extends StdSerializer<NottableString> {
    public NottableStringSerializer() {
        super(NottableString.class);
    }

    public void serialize(NottableString nottableString, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        if (nottableString.getParameterStyle() != null) {
            this.writeObject(nottableString, jgen, "value", nottableString.getValue());
        } else {
            jgen.writeString(NottableString.serialiseNottableString(nottableString));
        }
    }

    private void writeObject(NottableString nottableString, JsonGenerator jgen, String valueFieldName, Object value) throws IOException {
        jgen.writeStartObject();
        if (Boolean.TRUE.equals(nottableString.isNot())) {
            jgen.writeBooleanField("not", true);
        }
        if (Boolean.TRUE.equals(nottableString.isOptional())) {
            jgen.writeBooleanField("optional", true);
        }
        if (nottableString.getParameterStyle() != null) {
            jgen.writeObjectField("parameterStyle", (Object)nottableString.getParameterStyle());
        }
        jgen.writeObjectField(valueFieldName, value);
        jgen.writeEndObject();
    }
}

