/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.serialization.serializers.body;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import software.xdev.mockserver.serialization.model.StringBodyDTO;

public class StringBodyDTOSerializer
extends StdSerializer<StringBodyDTO> {
    private final boolean serialiseDefaultValues;

    public StringBodyDTOSerializer(boolean serialiseDefaultValues) {
        super(StringBodyDTO.class);
        this.serialiseDefaultValues = serialiseDefaultValues;
    }

    public void serialize(StringBodyDTO stringBodyDTO, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        boolean contentTypeFieldSet;
        boolean notFieldSetAndNotDefault = stringBodyDTO.getNot() != null && stringBodyDTO.getNot() != false;
        boolean optionalFieldSetAndNotDefault = stringBodyDTO.getOptional() != null && stringBodyDTO.getOptional() != false;
        boolean subStringFieldNotDefault = stringBodyDTO.isSubString();
        boolean bl = contentTypeFieldSet = stringBodyDTO.getContentType() != null;
        if (this.serialiseDefaultValues || notFieldSetAndNotDefault || optionalFieldSetAndNotDefault || contentTypeFieldSet || subStringFieldNotDefault) {
            jgen.writeStartObject();
            if (notFieldSetAndNotDefault) {
                jgen.writeBooleanField("not", true);
            }
            if (optionalFieldSetAndNotDefault) {
                jgen.writeBooleanField("optional", true);
            }
            jgen.writeStringField("type", stringBodyDTO.getType().name());
            jgen.writeStringField("string", stringBodyDTO.getString());
            if (stringBodyDTO.getRawBytes() != null) {
                jgen.writeObjectField("rawBytes", (Object)stringBodyDTO.getRawBytes());
            }
            if (subStringFieldNotDefault) {
                jgen.writeBooleanField("subString", true);
            }
            if (contentTypeFieldSet) {
                jgen.writeStringField("contentType", stringBodyDTO.getContentType());
            }
            jgen.writeEndObject();
        } else {
            jgen.writeString(stringBodyDTO.getString());
        }
    }
}

