/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.serialization.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import software.xdev.mockserver.model.ExpectationId;
import software.xdev.mockserver.model.HttpRequest;
import software.xdev.mockserver.model.RequestDefinition;
import software.xdev.mockserver.serialization.model.DTO;
import software.xdev.mockserver.serialization.model.HttpRequestDTO;
import software.xdev.mockserver.serialization.model.RequestDefinitionDTO;
import software.xdev.mockserver.verify.VerificationSequence;

public class VerificationSequenceDTO
implements DTO<VerificationSequence> {
    private List<RequestDefinitionDTO> httpRequests = new ArrayList<RequestDefinitionDTO>();
    private List<ExpectationId> expectationIds = new ArrayList<ExpectationId>();
    private Integer maximumNumberOfRequestToReturnInVerificationFailure;

    public VerificationSequenceDTO(VerificationSequence verification) {
        if (verification != null) {
            for (RequestDefinition httpRequest : verification.getHttpRequests()) {
                if (!(httpRequest instanceof HttpRequest)) continue;
                this.httpRequests.add(new HttpRequestDTO((HttpRequest)httpRequest));
            }
            this.expectationIds.addAll(verification.getExpectationIds());
            this.maximumNumberOfRequestToReturnInVerificationFailure = verification.getMaximumNumberOfRequestToReturnInVerificationFailure();
        }
    }

    public VerificationSequenceDTO() {
    }

    @Override
    public VerificationSequence buildObject() {
        ArrayList<RequestDefinition> httpRequests = new ArrayList<RequestDefinition>();
        for (RequestDefinitionDTO httpRequest : this.httpRequests) {
            httpRequests.add(httpRequest.buildObject());
        }
        return new VerificationSequence().withRequests(httpRequests).withExpectationIds(this.expectationIds).withMaximumNumberOfRequestToReturnInVerificationFailure(this.maximumNumberOfRequestToReturnInVerificationFailure);
    }

    public List<RequestDefinitionDTO> getHttpRequests() {
        return this.httpRequests;
    }

    public VerificationSequenceDTO setHttpRequests(List<RequestDefinitionDTO> httpRequests) {
        this.httpRequests = httpRequests;
        return this;
    }

    public List<ExpectationId> getExpectationIds() {
        return this.expectationIds;
    }

    public VerificationSequenceDTO setExpectationIds(List<ExpectationId> expectationIds) {
        this.expectationIds = expectationIds;
        return this;
    }

    public Integer getMaximumNumberOfRequestToReturnInVerificationFailure() {
        return this.maximumNumberOfRequestToReturnInVerificationFailure;
    }

    public VerificationSequenceDTO setMaximumNumberOfRequestToReturnInVerificationFailure(Integer maximumNumberOfRequestToReturnInVerificationFailure) {
        this.maximumNumberOfRequestToReturnInVerificationFailure = maximumNumberOfRequestToReturnInVerificationFailure;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VerificationSequenceDTO)) {
            return false;
        }
        VerificationSequenceDTO that = (VerificationSequenceDTO)o;
        if (!super.equals(o)) {
            return false;
        }
        return Objects.equals(this.getHttpRequests(), that.getHttpRequests()) && Objects.equals(this.getExpectationIds(), that.getExpectationIds()) && Objects.equals(this.getMaximumNumberOfRequestToReturnInVerificationFailure(), that.getMaximumNumberOfRequestToReturnInVerificationFailure());
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getHttpRequests(), this.getExpectationIds(), this.getMaximumNumberOfRequestToReturnInVerificationFailure());
    }
}

