/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.serialization.deserializers.condition;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import software.xdev.mockserver.serialization.model.VerificationTimesDTO;
import software.xdev.mockserver.verify.VerificationTimes;

public class VerificationTimesDTODeserializer
extends StdDeserializer<VerificationTimesDTO> {
    public VerificationTimesDTODeserializer() {
        super(VerificationTimesDTO.class);
    }

    public VerificationTimesDTO deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
        VerificationTimesDTO verificationTimesDTO = null;
        Integer count = null;
        Boolean exact = null;
        Integer atLeast = null;
        Integer atMost = null;
        while (jsonParser.nextToken() != JsonToken.END_OBJECT) {
            String fieldName = jsonParser.currentName();
            if ("count".equals(fieldName)) {
                jsonParser.nextToken();
                count = jsonParser.getIntValue();
            } else if ("exact".equals(fieldName)) {
                jsonParser.nextToken();
                exact = jsonParser.getBooleanValue();
            } else if ("atLeast".equals(fieldName)) {
                jsonParser.nextToken();
                atLeast = jsonParser.getIntValue();
            } else if ("atMost".equals(fieldName)) {
                jsonParser.nextToken();
                atMost = jsonParser.getIntValue();
            }
            if (atLeast != null || atMost != null) {
                verificationTimesDTO = new VerificationTimesDTO(VerificationTimes.between(atLeast != null ? atLeast : -1, atMost != null ? atMost : -1));
                continue;
            }
            if (count == null) continue;
            if (exact != null && exact.booleanValue()) {
                verificationTimesDTO = new VerificationTimesDTO(VerificationTimes.exactly(count));
                continue;
            }
            verificationTimesDTO = new VerificationTimesDTO(VerificationTimes.atLeast(count));
        }
        return verificationTimesDTO;
    }
}

