/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.serialization;

import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import software.xdev.mockserver.serialization.ObjectMapperFactory;
import software.xdev.mockserver.serialization.Serializer;
import software.xdev.mockserver.serialization.model.VerificationDTO;
import software.xdev.mockserver.verify.Verification;

public class VerificationSerializer
implements Serializer<Verification> {
    private final ObjectWriter objectWriter = ObjectMapperFactory.createObjectMapper(true, false, new JsonSerializer[0]);
    private final ObjectMapper objectMapper = ObjectMapperFactory.createObjectMapper();

    @Override
    public String serialize(Verification verification) {
        try {
            return this.objectWriter.writeValueAsString((Object)new VerificationDTO(verification));
        }
        catch (Exception e) {
            throw new IllegalStateException("Exception while serializing verification to JSON with value " + String.valueOf(verification), e);
        }
    }

    @Override
    public Verification deserialize(String jsonVerification) {
        try {
            VerificationDTO verificationDTO = (VerificationDTO)this.objectMapper.readValue(jsonVerification, VerificationDTO.class);
            if (verificationDTO != null) {
                return verificationDTO.buildObject();
            }
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("exception while parsing [" + jsonVerification + "] for Verification", ex);
        }
        return null;
    }

    @Override
    public Class<Verification> supportsType() {
        return Verification.class;
    }
}

