/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.serialization;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import software.xdev.mockserver.model.HttpRequest;
import software.xdev.mockserver.serialization.JsonArraySerializer;
import software.xdev.mockserver.serialization.ObjectMapperFactory;
import software.xdev.mockserver.serialization.Serializer;
import software.xdev.mockserver.serialization.model.HttpRequestDTO;
import software.xdev.mockserver.serialization.model.HttpRequestPrettyPrintedDTO;
import software.xdev.mockserver.util.StringUtils;

public class HttpRequestSerializer
implements Serializer<HttpRequest> {
    private final ObjectWriter objectWriter = ObjectMapperFactory.createObjectMapper(true, false, new JsonSerializer[0]);
    private final ObjectMapper objectMapper = ObjectMapperFactory.createObjectMapper();
    private final JsonArraySerializer jsonArraySerializer = new JsonArraySerializer();

    @Override
    public String serialize(HttpRequest httpRequest) {
        return this.serialize(false, httpRequest);
    }

    public String serialize(boolean prettyPrint, HttpRequest httpRequest) {
        try {
            if (prettyPrint) {
                return this.objectWriter.writeValueAsString((Object)new HttpRequestPrettyPrintedDTO(httpRequest));
            }
            return this.objectWriter.writeValueAsString((Object)new HttpRequestDTO(httpRequest));
        }
        catch (Exception e) {
            throw new RuntimeException("Exception while serializing HttpRequest to JSON with value " + String.valueOf(httpRequest), e);
        }
    }

    @Override
    public String serialize(List<HttpRequest> httpRequests) {
        return this.serialize(false, httpRequests);
    }

    public String serialize(boolean prettyPrint, List<HttpRequest> httpRequests) {
        return this.serialize(prettyPrint, httpRequests.toArray(new HttpRequest[0]));
    }

    @Override
    public String serialize(HttpRequest ... httpRequests) {
        return this.serialize(false, httpRequests);
    }

    public String serialize(boolean prettyPrint, HttpRequest ... httpRequests) {
        try {
            if (httpRequests != null && httpRequests.length > 0) {
                if (prettyPrint) {
                    HttpRequestPrettyPrintedDTO[] httpRequestTemplateObjects = new HttpRequestPrettyPrintedDTO[httpRequests.length];
                    for (int i = 0; i < httpRequests.length; ++i) {
                        httpRequestTemplateObjects[i] = new HttpRequestPrettyPrintedDTO(httpRequests[i]);
                    }
                    return this.objectWriter.writeValueAsString((Object)httpRequestTemplateObjects);
                }
                HttpRequestDTO[] httpRequestDTOs = new HttpRequestDTO[httpRequests.length];
                for (int i = 0; i < httpRequests.length; ++i) {
                    httpRequestDTOs[i] = new HttpRequestDTO(httpRequests[i]);
                }
                return this.objectWriter.writeValueAsString((Object)httpRequestDTOs);
            }
            return "[]";
        }
        catch (Exception e) {
            throw new IllegalStateException("Exception while serializing HttpRequest to JSON with value " + String.valueOf(Arrays.asList(httpRequests)), e);
        }
    }

    @Override
    public HttpRequest deserialize(String jsonHttpRequest) {
        if (jsonHttpRequest.contains("\"httpRequest\"")) {
            try {
                JsonNode jsonNode = this.objectMapper.readTree(jsonHttpRequest);
                if (jsonNode.has("httpRequest")) {
                    jsonHttpRequest = jsonNode.get("httpRequest").toString();
                }
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("exception while parsing [" + jsonHttpRequest + "] for HttpRequest", ex);
            }
        }
        HttpRequest httpRequest = null;
        try {
            HttpRequestDTO httpRequestDTO = (HttpRequestDTO)this.objectMapper.readValue(jsonHttpRequest, HttpRequestDTO.class);
            if (httpRequestDTO != null) {
                httpRequest = httpRequestDTO.buildObject();
            }
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("exception while parsing [" + jsonHttpRequest + "] for HttpRequest", ex);
        }
        return httpRequest;
    }

    @Override
    public Class<HttpRequest> supportsType() {
        return HttpRequest.class;
    }

    public HttpRequest[] deserializeArray(String jsonHttpRequests) {
        ArrayList<HttpRequest> httpRequests = new ArrayList<HttpRequest>();
        if (StringUtils.isBlank(jsonHttpRequests)) {
            throw new IllegalArgumentException("1 error:\n - a request or request array is required but value was \"" + jsonHttpRequests + "\"");
        }
        List<String> jsonRequestList = this.jsonArraySerializer.splitJSONArray(jsonHttpRequests);
        if (jsonRequestList.isEmpty()) {
            throw new IllegalArgumentException("1 error:\n - a request or array of request is required");
        }
        ArrayList<String> validationErrorsList = new ArrayList<String>();
        for (String jsonRequest : jsonRequestList) {
            try {
                httpRequests.add(this.deserialize(jsonRequest));
            }
            catch (IllegalArgumentException iae) {
                validationErrorsList.add(iae.getMessage());
            }
        }
        if (!validationErrorsList.isEmpty()) {
            throw new IllegalArgumentException((validationErrorsList.size() > 1 ? "[" : "") + String.join((CharSequence)",\n", validationErrorsList) + (validationErrorsList.size() > 1 ? "]" : ""));
        }
        return httpRequests.toArray(new HttpRequest[0]);
    }
}

