/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import software.xdev.mockserver.model.NottableOptionalString;
import software.xdev.mockserver.model.ObjectWithJsonToString;
import software.xdev.mockserver.model.ParameterStyle;
import software.xdev.mockserver.util.StringUtils;

public class NottableString
extends ObjectWithJsonToString
implements Comparable<NottableString> {
    public static final char NOT_CHAR = '!';
    private static final String EMPTY_STRING = "";
    private final String value;
    private final boolean isBlank;
    private final Boolean not;
    private final int hashCode;
    private final String json;
    private Pattern pattern;
    private ParameterStyle parameterStyle;

    NottableString(String value, Boolean not) {
        this.value = value;
        this.isBlank = StringUtils.isBlank(value);
        this.not = not != null ? not : Boolean.FALSE;
        this.hashCode = Objects.hash(this.value, this.not);
        this.json = this.serialise();
    }

    NottableString(String value) {
        this.isBlank = StringUtils.isBlank(value);
        if (!this.isBlank && value.charAt(0) == '!') {
            this.value = value.substring(1);
            this.not = Boolean.TRUE;
        } else {
            this.value = value;
            this.not = Boolean.FALSE;
        }
        this.hashCode = Objects.hash(this.value, this.not);
        this.json = this.serialise();
    }

    private String serialise() {
        if (this.isOptional() || this.not.booleanValue()) {
            return (this.isOptional() ? String.valueOf('?') : EMPTY_STRING) + (this.not != false ? String.valueOf('!') : EMPTY_STRING) + (!this.isBlank ? this.value : EMPTY_STRING);
        }
        if (this.isBlank) {
            return EMPTY_STRING;
        }
        return this.value;
    }

    public static List<NottableString> deserializeNottableStrings(String ... strings) {
        LinkedList<NottableString> nottableStrings = new LinkedList<NottableString>();
        for (String string : strings) {
            nottableStrings.add(NottableString.string(string));
        }
        return nottableStrings;
    }

    public static List<NottableString> deserializeNottableStrings(List<String> strings) {
        LinkedList<NottableString> nottableStrings = new LinkedList<NottableString>();
        for (String string : strings) {
            nottableStrings.add(NottableString.string(string));
        }
        return nottableStrings;
    }

    public static String serialiseNottableString(NottableString nottableString) {
        return nottableString.toString();
    }

    public static List<String> serialiseNottableStrings(Collection<NottableString> nottableStrings) {
        LinkedList<String> strings = new LinkedList<String>();
        for (NottableString nottableString : nottableStrings) {
            strings.add(nottableString.toString());
        }
        return strings;
    }

    public static NottableString string(String value, Boolean not) {
        return new NottableString(value, not);
    }

    public static NottableString string(String value) {
        Boolean not = null;
        boolean optional = false;
        if (StringUtils.isNotBlank(value)) {
            if (value.charAt(0) == '?') {
                optional = true;
                value = value.substring(1);
            }
            if (value.charAt(0) == '!') {
                not = true;
                value = value.substring(1);
            }
            if (value.charAt(0) == '?') {
                optional = true;
                value = value.substring(1);
            }
        }
        if (optional) {
            return NottableOptionalString.optional(value, not);
        }
        return new NottableString(value, not);
    }

    public static NottableString not(String value) {
        return new NottableString(value, Boolean.TRUE);
    }

    public static List<NottableString> strings(String ... values) {
        ArrayList<NottableString> nottableValues = new ArrayList<NottableString>();
        if (values != null) {
            for (String value : values) {
                nottableValues.add(NottableString.string(value));
            }
        }
        return nottableValues;
    }

    public static List<NottableString> strings(Collection<String> values) {
        ArrayList<NottableString> nottableValues = new ArrayList<NottableString>();
        if (values != null) {
            for (String value : values) {
                nottableValues.add(NottableString.string(value));
            }
        }
        return nottableValues;
    }

    public String getValue() {
        return this.value;
    }

    @JsonIgnore
    public boolean isNot() {
        return this.not;
    }

    public boolean isOptional() {
        return false;
    }

    public ParameterStyle getParameterStyle() {
        return this.parameterStyle;
    }

    public NottableString withStyle(ParameterStyle style) {
        if (style != null && style.equals((Object)ParameterStyle.DEEP_OBJECT)) {
            throw new IllegalArgumentException("deep object style is not supported");
        }
        this.parameterStyle = style;
        return this;
    }

    public NottableString lowercase() {
        return new NottableString(this.value.toLowerCase(), this.not);
    }

    public boolean equalsIgnoreCase(Object other) {
        return this.equals(other, true);
    }

    private boolean equals(Object other, boolean ignoreCase) {
        if (other instanceof String) {
            String s = (String)other;
            if (ignoreCase) {
                return this.not.booleanValue() != s.equalsIgnoreCase(this.value);
            }
            return this.not.booleanValue() != other.equals(this.value);
        }
        if (other instanceof NottableString) {
            boolean reverse;
            NottableString that = (NottableString)other;
            if (that.getValue() == null) {
                return this.value == null;
            }
            boolean bl = reverse = !Objects.equals(that.not, this.not);
            if (ignoreCase) {
                return reverse != that.getValue().equalsIgnoreCase(this.value);
            }
            return reverse != that.getValue().equals(this.value);
        }
        return false;
    }

    public boolean isBlank() {
        return this.isBlank;
    }

    public boolean matches(String input) {
        if (this.pattern == null) {
            this.pattern = Pattern.compile(this.getValue(), 98);
        }
        return this.pattern.matcher(input).matches();
    }

    public boolean equals(Object other) {
        if (other instanceof String) {
            return this.not.booleanValue() != other.equals(this.value);
        }
        if (other instanceof NottableString) {
            NottableString nottableString = (NottableString)other;
            return this.equalsValue(nottableString);
        }
        return false;
    }

    private boolean equalsString(NottableString one, NottableString two) {
        if (one.value == null && two.value == null) {
            return true;
        }
        if (one.value == null || two.value == null) {
            return false;
        }
        boolean reverse = !Objects.equals(two.not, one.not);
        return reverse != two.value.equals(one.value);
    }

    private boolean equalsValue(NottableString other) {
        return this.equalsString(this, other);
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public String toString() {
        return this.json;
    }

    @Override
    public int compareTo(NottableString other) {
        return other.getValue().compareTo(this.getValue());
    }
}

