/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.model;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import software.xdev.mockserver.model.KeyMatchStyle;
import software.xdev.mockserver.model.KeyToMultiValue;
import software.xdev.mockserver.model.NottableString;
import software.xdev.mockserver.model.ObjectWithJsonToString;

public abstract class KeysToMultiValues<T extends KeyToMultiValue, K extends KeysToMultiValues>
extends ObjectWithJsonToString {
    private KeyMatchStyle keyMatchStyle = KeyMatchStyle.SUB_SET;
    private final Map<NottableString, List<NottableString>> multimap;
    private final K k = this;

    protected KeysToMultiValues() {
        this.multimap = new LinkedHashMap<NottableString, List<NottableString>>();
    }

    protected KeysToMultiValues(Map<NottableString, List<NottableString>> multimap) {
        this.multimap = new LinkedHashMap<NottableString, List<NottableString>>(multimap);
    }

    public abstract T build(NottableString var1, Collection<NottableString> var2);

    protected abstract void isModified();

    public KeyMatchStyle getKeyMatchStyle() {
        return this.keyMatchStyle;
    }

    public KeysToMultiValues<T, K> withKeyMatchStyle(KeyMatchStyle keyMatchStyle) {
        this.keyMatchStyle = keyMatchStyle;
        return this;
    }

    public K withEntries(Map<String, List<String>> entries) {
        this.isModified();
        this.multimap.clear();
        for (String name : entries.keySet()) {
            for (String value : entries.get(name)) {
                this.withEntry(name, value);
            }
        }
        return this.k;
    }

    public K withEntries(List<T> entries) {
        this.isModified();
        this.multimap.clear();
        if (entries != null) {
            for (KeyToMultiValue entry : entries) {
                this.withEntry(entry);
            }
        }
        return this.k;
    }

    @SafeVarargs
    public final K withEntries(T ... entries) {
        if (KeysToMultiValues.arrayIsNotEmpty(entries)) {
            this.withEntries(Arrays.asList(entries));
        }
        return this.k;
    }

    public K withEntry(T entry) {
        if (entry != null) {
            this.isModified();
            if (((KeyToMultiValue)entry).getValues().isEmpty()) {
                this.multimap.put(((KeyToMultiValue)entry).getName(), null);
            } else {
                this.multimap.put(((KeyToMultiValue)entry).getName(), ((KeyToMultiValue)entry).getValues());
            }
        }
        return this.k;
    }

    public K withEntry(String name, String ... values) {
        this.isModified();
        if (values == null || values.length == 0) {
            this.multimap.put(NottableString.string(name), new ArrayList<NottableString>(List.of(NottableString.string(""))));
        } else {
            this.multimap.put(NottableString.string(name), NottableString.deserializeNottableStrings(values));
        }
        return this.k;
    }

    public K withEntry(String name, List<String> values) {
        this.isModified();
        if (values == null || values.isEmpty()) {
            this.multimap.remove(NottableString.string(name));
        } else {
            this.multimap.put(NottableString.string(name), NottableString.deserializeNottableStrings(values));
        }
        return this.k;
    }

    public K withEntry(NottableString name, List<NottableString> values) {
        if (values != null) {
            this.isModified();
            this.multimap.put(name, values);
        }
        return this.k;
    }

    public K withEntry(NottableString name, NottableString ... values) {
        if (KeysToMultiValues.arrayIsNotEmpty(values)) {
            this.withEntry(name, Arrays.asList(values));
        }
        return this.k;
    }

    public boolean remove(String name) {
        boolean exists = false;
        if (name != null) {
            this.isModified();
            for (NottableString key : this.multimap.keySet().toArray(new NottableString[0])) {
                if (!key.equalsIgnoreCase(name)) continue;
                this.multimap.remove(key);
                exists = true;
            }
        }
        return exists;
    }

    public boolean remove(NottableString name) {
        boolean exists = false;
        if (name != null) {
            this.isModified();
            for (NottableString key : this.multimap.keySet().toArray(new NottableString[0])) {
                if (!key.equalsIgnoreCase(name)) continue;
                this.multimap.remove(key);
                exists = true;
            }
        }
        return exists;
    }

    public K replaceEntry(T entry) {
        if (entry != null) {
            this.isModified();
            this.remove(((KeyToMultiValue)entry).getName());
            this.multimap.put(((KeyToMultiValue)entry).getName(), ((KeyToMultiValue)entry).getValues());
        }
        return this.k;
    }

    public K replaceEntryIfExists(T entry) {
        if (entry != null) {
            this.isModified();
            if (this.remove(((KeyToMultiValue)entry).getName())) {
                this.multimap.put(((KeyToMultiValue)entry).getName(), ((KeyToMultiValue)entry).getValues());
            }
        }
        return this.k;
    }

    public K replaceEntry(String name, String ... values) {
        if (KeysToMultiValues.arrayIsNotEmpty(values)) {
            this.isModified();
            this.remove(name);
            this.multimap.put(NottableString.string(name), NottableString.deserializeNottableStrings(values));
        }
        return this.k;
    }

    public List<T> getEntries() {
        if (!this.isEmpty()) {
            ArrayList<T> headers = new ArrayList<T>();
            for (NottableString nottableString : this.multimap.keySet().toArray(new NottableString[0])) {
                headers.add(this.build(nottableString, (Collection<NottableString>)this.multimap.get(nottableString)));
            }
            return headers;
        }
        return Collections.emptyList();
    }

    public Set<NottableString> keySet() {
        return this.multimap.keySet();
    }

    public Collection<NottableString> getValues(NottableString key) {
        return this.multimap.get(key);
    }

    public Map<NottableString, List<NottableString>> getMultimap() {
        return this.multimap;
    }

    public List<String> getValues(String name) {
        if (!this.isEmpty() && name != null) {
            ArrayList<String> values = new ArrayList<String>();
            for (NottableString key : this.multimap.keySet().toArray(new NottableString[0])) {
                if (key == null || !key.equalsIgnoreCase(name)) continue;
                values.addAll(NottableString.serialiseNottableStrings((Collection<NottableString>)this.multimap.get(key)));
            }
            return values;
        }
        return Collections.emptyList();
    }

    String getFirstValue(String name) {
        if (!this.isEmpty()) {
            for (NottableString key : this.multimap.keySet().toArray(new NottableString[0])) {
                NottableString next;
                Collection nottableStrings;
                if (key == null || !key.equalsIgnoreCase(name) || (nottableStrings = (Collection)this.multimap.get(key)).isEmpty() || (next = (NottableString)nottableStrings.iterator().next()) == null) continue;
                return next.getValue();
            }
        }
        return "";
    }

    public boolean containsEntry(String name) {
        if (!this.isEmpty()) {
            for (NottableString key : this.multimap.keySet().toArray(new NottableString[0])) {
                if (key == null || !key.equalsIgnoreCase(name)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsEntry(String name, String value) {
        return this.containsEntry(NottableString.string(name), NottableString.string(value));
    }

    boolean containsEntry(NottableString name, NottableString value) {
        if (!this.isEmpty() && name != null && value != null) {
            for (NottableString entryKey : this.multimap.keySet().toArray(new NottableString[0])) {
                Collection nottableStrings;
                if (entryKey == null || !entryKey.equalsIgnoreCase(name) || (nottableStrings = (Collection)this.multimap.get(entryKey)) == null) continue;
                for (NottableString entryValue : nottableStrings.toArray(new NottableString[0])) {
                    if (!value.equalsIgnoreCase(entryValue)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isEmpty() {
        return this.multimap.isEmpty();
    }

    public abstract K clone();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof KeysToMultiValues)) {
            return false;
        }
        KeysToMultiValues that = (KeysToMultiValues)o;
        return Objects.equals(this.multimap, that.multimap);
    }

    public int hashCode() {
        return Objects.hash(this.multimap);
    }

    private static boolean arrayIsNotEmpty(Object array) {
        return !KeysToMultiValues.arrayIsEmpty(array);
    }

    private static boolean arrayIsEmpty(Object array) {
        return array == null || Array.getLength(array) == 0;
    }
}

