/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import software.xdev.mockserver.model.KeyAndValue;
import software.xdev.mockserver.model.NottableString;
import software.xdev.mockserver.model.ObjectWithJsonToString;
import software.xdev.mockserver.util.StringUtils;

public abstract class KeysAndValues<T extends KeyAndValue, K extends KeysAndValues>
extends ObjectWithJsonToString {
    private final Map<NottableString, NottableString> map;

    protected KeysAndValues() {
        this.map = new LinkedHashMap<NottableString, NottableString>();
    }

    protected KeysAndValues(Map<NottableString, NottableString> map) {
        this.map = new LinkedHashMap<NottableString, NottableString>(map);
    }

    public abstract T build(NottableString var1, NottableString var2);

    public K withEntries(List<T> entries) {
        this.map.clear();
        if (entries != null) {
            for (KeyAndValue cookie : entries) {
                this.withEntry(cookie);
            }
        }
        return (K)this;
    }

    public K withEntries(T ... entries) {
        if (entries != null) {
            this.withEntries(Arrays.asList(entries));
        }
        return (K)this;
    }

    public K withEntry(T entry) {
        if (entry != null) {
            this.map.put(((KeyAndValue)entry).getName(), ((KeyAndValue)entry).getValue());
        }
        return (K)this;
    }

    public K withEntry(String name, String value) {
        this.map.put(NottableString.string(name), NottableString.string(value));
        return (K)this;
    }

    public K withEntry(NottableString name, NottableString value) {
        this.map.put(name, value);
        return (K)this;
    }

    public K replaceEntryIfExists(T entry) {
        if (entry != null && this.remove(((KeyAndValue)entry).getName())) {
            this.map.put(((KeyAndValue)entry).getName(), ((KeyAndValue)entry).getValue());
        }
        return (K)this;
    }

    public List<T> getEntries() {
        if (!this.map.isEmpty()) {
            ArrayList<T> cookies = new ArrayList<T>();
            for (NottableString nottableString : this.map.keySet()) {
                cookies.add(this.build(nottableString, this.map.get(nottableString)));
            }
            return cookies;
        }
        return Collections.emptyList();
    }

    public Map<NottableString, NottableString> getMap() {
        return this.map;
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean remove(NottableString name) {
        return this.remove(name.getValue());
    }

    public boolean remove(String name) {
        if (StringUtils.isNotBlank(name)) {
            return this.map.remove(NottableString.string(name)) != null;
        }
        return false;
    }

    public abstract K clone();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof KeysAndValues)) {
            return false;
        }
        KeysAndValues that = (KeysAndValues)o;
        return Objects.equals(this.getMap(), that.getMap());
    }

    public int hashCode() {
        return Objects.hashCode(this.getMap());
    }
}

