/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.configuration;

import java.net.InetSocketAddress;
import java.util.function.Supplier;
import software.xdev.mockserver.configuration.ConfigurationProperties;

public class Configuration {
    protected Integer maxWebSocketExpectations;
    protected Integer clientNioEventLoopThreadCount;
    protected Integer webSocketClientEventLoopThreadCount;
    protected Long maxFutureTimeoutInMillis;
    protected Long maxSocketTimeoutInMillis;
    protected Long socketConnectionTimeoutInMillis;
    private Boolean forwardBinaryRequestsWithoutWaitingForResponse;
    protected Boolean attemptToProxyIfNoMatchingExpectation;
    protected InetSocketAddress forwardHttpProxy;
    protected InetSocketAddress forwardSocksProxy;
    protected String forwardProxyAuthenticationUsername;
    protected String forwardProxyAuthenticationPassword;

    public static Configuration configuration() {
        return new Configuration();
    }

    public Integer maxWebSocketExpectations() {
        return Configuration.ifNullReturn(this.maxWebSocketExpectations, ConfigurationProperties::maxWebSocketExpectations);
    }

    public Configuration maxWebSocketExpectations(Integer maxWebSocketExpectations) {
        this.maxWebSocketExpectations = maxWebSocketExpectations;
        return this;
    }

    public Integer clientNioEventLoopThreadCount() {
        return Configuration.ifNullReturn(this.clientNioEventLoopThreadCount, ConfigurationProperties::clientNioEventLoopThreadCount);
    }

    public Configuration clientNioEventLoopThreadCount(Integer clientNioEventLoopThreadCount) {
        this.clientNioEventLoopThreadCount = clientNioEventLoopThreadCount;
        return this;
    }

    public Integer webSocketClientEventLoopThreadCount() {
        return Configuration.ifNullReturn(this.webSocketClientEventLoopThreadCount, ConfigurationProperties::webSocketClientEventLoopThreadCount);
    }

    public Configuration webSocketClientEventLoopThreadCount(Integer webSocketClientEventLoopThreadCount) {
        this.webSocketClientEventLoopThreadCount = webSocketClientEventLoopThreadCount;
        return this;
    }

    public Long maxFutureTimeoutInMillis() {
        return Configuration.ifNullReturn(this.maxFutureTimeoutInMillis, ConfigurationProperties::maxFutureTimeout);
    }

    public Configuration maxFutureTimeoutInMillis(Long maxFutureTimeoutInMillis) {
        this.maxFutureTimeoutInMillis = maxFutureTimeoutInMillis;
        return this;
    }

    public Long maxSocketTimeoutInMillis() {
        return Configuration.ifNullReturn(this.maxSocketTimeoutInMillis, ConfigurationProperties::maxSocketTimeout);
    }

    public Configuration maxSocketTimeoutInMillis(Long maxSocketTimeoutInMillis) {
        this.maxSocketTimeoutInMillis = maxSocketTimeoutInMillis;
        return this;
    }

    public Long socketConnectionTimeoutInMillis() {
        return Configuration.ifNullReturn(this.socketConnectionTimeoutInMillis, ConfigurationProperties::socketConnectionTimeout);
    }

    public Configuration socketConnectionTimeoutInMillis(Long socketConnectionTimeoutInMillis) {
        this.socketConnectionTimeoutInMillis = socketConnectionTimeoutInMillis;
        return this;
    }

    public Boolean forwardBinaryRequestsWithoutWaitingForResponse() {
        return Configuration.ifNullReturn(this.forwardBinaryRequestsWithoutWaitingForResponse, ConfigurationProperties::forwardBinaryRequestsWithoutWaitingForResponse);
    }

    public Configuration forwardBinaryRequestsWithoutWaitingForResponse(Boolean forwardBinaryRequestsWithoutWaitingForResponse) {
        this.forwardBinaryRequestsWithoutWaitingForResponse = forwardBinaryRequestsWithoutWaitingForResponse;
        return this;
    }

    public Boolean attemptToProxyIfNoMatchingExpectation() {
        return Configuration.ifNullReturn(this.attemptToProxyIfNoMatchingExpectation, ConfigurationProperties::attemptToProxyIfNoMatchingExpectation);
    }

    public Configuration attemptToProxyIfNoMatchingExpectation(Boolean attemptToProxyIfNoMatchingExpectation) {
        this.attemptToProxyIfNoMatchingExpectation = attemptToProxyIfNoMatchingExpectation;
        return this;
    }

    public InetSocketAddress forwardHttpProxy() {
        return Configuration.ifNullReturn(this.forwardHttpProxy, ConfigurationProperties::forwardHttpProxy);
    }

    public Configuration forwardHttpProxy(InetSocketAddress forwardHttpProxy) {
        this.forwardHttpProxy = forwardHttpProxy;
        return this;
    }

    public InetSocketAddress forwardSocksProxy() {
        return Configuration.ifNullReturn(this.forwardSocksProxy, ConfigurationProperties::forwardSocksProxy);
    }

    public Configuration forwardSocksProxy(InetSocketAddress forwardSocksProxy) {
        this.forwardSocksProxy = forwardSocksProxy;
        return this;
    }

    public String forwardProxyAuthenticationUsername() {
        return Configuration.ifNullReturn(this.forwardProxyAuthenticationUsername, ConfigurationProperties::forwardProxyAuthenticationUsername);
    }

    public Configuration forwardProxyAuthenticationUsername(String forwardProxyAuthenticationUsername) {
        this.forwardProxyAuthenticationUsername = forwardProxyAuthenticationUsername;
        return this;
    }

    public String forwardProxyAuthenticationPassword() {
        return Configuration.ifNullReturn(this.forwardProxyAuthenticationPassword, ConfigurationProperties::forwardProxyAuthenticationPassword);
    }

    public Configuration forwardProxyAuthenticationPassword(String forwardProxyAuthenticationPassword) {
        this.forwardProxyAuthenticationPassword = forwardProxyAuthenticationPassword;
        return this;
    }

    protected static <T> T ifNullReturn(T value, Supplier<T> otherSupplier) {
        return value != null ? value : otherSupplier.get();
    }
}

