/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.charset.Charset;
import software.xdev.mockserver.model.BinaryBody;
import software.xdev.mockserver.model.Body;
import software.xdev.mockserver.model.BodyWithContentType;
import software.xdev.mockserver.model.MediaType;
import software.xdev.mockserver.model.StringBody;
import software.xdev.mockserver.util.StringUtils;

public class BodyDecoderEncoder {
    public ByteBuf bodyToByteBuf(Body body, String contentTypeHeader) {
        byte[] bytes = this.bodyToBytes(body, contentTypeHeader);
        return bytes != null ? Unpooled.copiedBuffer((byte[])bytes) : Unpooled.buffer((int)0, (int)0);
    }

    public ByteBuf[] bodyToByteBuf(Body body, String contentTypeHeader, int chunkSize) {
        byte[][] chunks = BodyDecoderEncoder.split(this.bodyToBytes(body, contentTypeHeader), chunkSize);
        ByteBuf[] byteBufs = new ByteBuf[chunks.length];
        for (int i = 0; i < chunks.length; ++i) {
            byteBufs[i] = chunks[i] != null ? Unpooled.copiedBuffer((byte[])chunks[i]) : Unpooled.buffer((int)0, (int)0);
        }
        return byteBufs;
    }

    public static byte[][] split(byte[] array, int chunkSize) {
        if (chunkSize >= array.length) {
            return new byte[][]{array};
        }
        int numOfChunks = (array.length + chunkSize - 1) / chunkSize;
        byte[][] output = new byte[numOfChunks][];
        for (int i = 0; i < numOfChunks; ++i) {
            int start = i * chunkSize;
            int length = Math.min(array.length - start, chunkSize);
            byte[] temp = new byte[length];
            System.arraycopy(array, start, temp, 0, length);
            output[i] = temp;
        }
        return output;
    }

    byte[] bodyToBytes(Body body, String contentTypeHeader) {
        if (body == null) {
            return null;
        }
        if (body instanceof BinaryBody) {
            return body.getRawBytes();
        }
        Object t = body.getValue();
        if (t instanceof String) {
            String bodyString = (String)t;
            Charset contentTypeCharset = MediaType.parse(contentTypeHeader).getCharsetOrDefault();
            Charset bodyCharset = body.getCharset(contentTypeCharset);
            return bodyString.getBytes(bodyCharset != null ? bodyCharset : MediaType.DEFAULT_TEXT_HTTP_CHARACTER_SET);
        }
        return body.getRawBytes();
    }

    public BodyWithContentType byteBufToBody(ByteBuf content, String contentTypeHeader) {
        if (content != null && content.readableBytes() > 0) {
            byte[] bodyBytes = new byte[content.readableBytes()];
            content.readBytes(bodyBytes);
            return this.bytesToBody(bodyBytes, contentTypeHeader);
        }
        return null;
    }

    public BodyWithContentType bytesToBody(byte[] bodyBytes, String contentTypeHeader) {
        if (bodyBytes.length == 0) {
            return null;
        }
        MediaType mediaType = MediaType.parse(contentTypeHeader);
        return mediaType.isString() ? new StringBody(new String(bodyBytes, mediaType.getCharsetOrDefault()), bodyBytes, false, StringUtils.isNotBlank(contentTypeHeader) ? mediaType : null) : new BinaryBody(bodyBytes, mediaType);
    }
}

