/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.closurecallback.websocketregistry;

import java.util.Collections;
import java.util.Map;
import software.xdev.mockserver.collections.CircularHashMap;
import software.xdev.mockserver.configuration.ConfigurationProperties;
import software.xdev.mockserver.mock.action.ExpectationCallback;
import software.xdev.mockserver.mock.action.ExpectationForwardAndResponseCallback;
import software.xdev.mockserver.mock.action.ExpectationForwardCallback;
import software.xdev.mockserver.mock.action.ExpectationResponseCallback;

public final class LocalCallbackRegistry {
    static boolean enabled = true;
    private static Map<String, ExpectationResponseCallback> responseCallbackRegistry;
    private static Map<String, ExpectationForwardCallback> forwardCallbackRegistry;
    private static Map<String, ExpectationForwardAndResponseCallback> forwardAndResponseCallbackRegistry;
    private static int maxWebSocketExpectations;

    public static void setMaxWebSocketExpectations(int maxWebSocketExpectations) {
        LocalCallbackRegistry.maxWebSocketExpectations = maxWebSocketExpectations;
    }

    public static Map<String, ExpectationResponseCallback> responseCallbackRegistry() {
        if (responseCallbackRegistry == null) {
            responseCallbackRegistry = Collections.synchronizedMap(new CircularHashMap(maxWebSocketExpectations));
        }
        return responseCallbackRegistry;
    }

    public static Map<String, ExpectationForwardCallback> forwardCallbackRegistry() {
        if (forwardCallbackRegistry == null) {
            forwardCallbackRegistry = Collections.synchronizedMap(new CircularHashMap(maxWebSocketExpectations));
        }
        return forwardCallbackRegistry;
    }

    public static Map<String, ExpectationForwardAndResponseCallback> forwardAndResponseCallbackRegistry() {
        if (forwardAndResponseCallbackRegistry == null) {
            forwardAndResponseCallbackRegistry = Collections.synchronizedMap(new CircularHashMap(maxWebSocketExpectations));
        }
        return forwardAndResponseCallbackRegistry;
    }

    public static void registerCallback(String clientId, ExpectationCallback<?> expectationCallback) {
        if (enabled && expectationCallback != null) {
            if (expectationCallback instanceof ExpectationResponseCallback) {
                ExpectationResponseCallback callback = (ExpectationResponseCallback)expectationCallback;
                LocalCallbackRegistry.responseCallbackRegistry().put(clientId, callback);
            } else if (expectationCallback instanceof ExpectationForwardAndResponseCallback) {
                ExpectationForwardAndResponseCallback callback = (ExpectationForwardAndResponseCallback)expectationCallback;
                LocalCallbackRegistry.forwardAndResponseCallbackRegistry().put(clientId, callback);
            } else if (expectationCallback instanceof ExpectationForwardCallback) {
                ExpectationForwardCallback callback = (ExpectationForwardCallback)expectationCallback;
                LocalCallbackRegistry.forwardCallbackRegistry().put(clientId, callback);
            }
        }
    }

    public static void unregisterCallback(String clientId) {
        LocalCallbackRegistry.responseCallbackRegistry().remove(clientId);
        LocalCallbackRegistry.forwardAndResponseCallbackRegistry().remove(clientId);
        LocalCallbackRegistry.forwardCallbackRegistry().remove(clientId);
    }

    public static boolean responseClientExists(String clientId) {
        return LocalCallbackRegistry.responseCallbackRegistry().containsKey(clientId);
    }

    public static boolean forwardClientExists(String clientId) {
        return LocalCallbackRegistry.forwardCallbackRegistry().containsKey(clientId) || LocalCallbackRegistry.forwardAndResponseCallbackRegistry().containsKey(clientId);
    }

    public static ExpectationResponseCallback retrieveResponseCallback(String clientId) {
        return LocalCallbackRegistry.responseCallbackRegistry().get(clientId);
    }

    public static ExpectationForwardCallback retrieveForwardCallback(String clientId) {
        ExpectationForwardCallback expectationForwardCallback = LocalCallbackRegistry.forwardCallbackRegistry().get(clientId);
        if (expectationForwardCallback == null) {
            return LocalCallbackRegistry.retrieveForwardAndResponseCallback(clientId);
        }
        return expectationForwardCallback;
    }

    public static ExpectationForwardAndResponseCallback retrieveForwardAndResponseCallback(String clientId) {
        return LocalCallbackRegistry.forwardAndResponseCallbackRegistry().get(clientId);
    }

    private LocalCallbackRegistry() {
    }

    static {
        maxWebSocketExpectations = ConfigurationProperties.maxWebSocketExpectations();
    }
}

