/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.closurecallback.websocketclient;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.xdev.mockserver.closurecallback.websocketclient.WebSocketClient;
import software.xdev.mockserver.closurecallback.websocketclient.WebSocketException;
import software.xdev.mockserver.logging.LoggingHandler;
import software.xdev.mockserver.mappers.FullHttpResponseToMockServerHttpResponse;
import software.xdev.mockserver.model.MediaType;
import software.xdev.mockserver.util.StringUtils;

public class WebSocketClientHandler
extends SimpleChannelInboundHandler<Object> {
    private static final Logger LOG = LoggerFactory.getLogger(WebSocketClientHandler.class);
    private final WebSocketClient webSocketClient;
    private final WebSocketClientHandshaker handshaker;
    private final String clientId;

    WebSocketClientHandler(String clientId, InetSocketAddress serverAddress, String contextPath, WebSocketClient webSocketClient) throws URISyntaxException {
        this.clientId = clientId;
        this.handshaker = WebSocketClientHandshakerFactory.newHandshaker((URI)new URI("ws://" + serverAddress.getHostName() + ":" + serverAddress.getPort() + this.cleanContextPath(contextPath) + "/_mockserver_callback_websocket"), (WebSocketVersion)WebSocketVersion.V13, null, (boolean)false, (HttpHeaders)new DefaultHttpHeaders().add("X-CLIENT-REGISTRATION-ID", (Object)clientId), (int)Integer.MAX_VALUE);
        this.webSocketClient = webSocketClient;
    }

    private String cleanContextPath(String contextPath) {
        if (StringUtils.isNotBlank(contextPath)) {
            return (!contextPath.startsWith("/") ? "/" : "") + contextPath;
        }
        return "";
    }

    public void channelActive(ChannelHandlerContext ctx) {
        this.handshaker.handshake(ctx.channel());
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Web socket client disconnected");
        }
    }

    public void channelRead0(ChannelHandlerContext ctx, Object msg) {
        Channel ch = ctx.channel();
        if (LOG.isTraceEnabled()) {
            LOG.trace("Web socket client handshake handler received {}", msg);
        }
        if (msg instanceof FullHttpResponse) {
            FullHttpResponse httpResponse = (FullHttpResponse)msg;
            CompletableFuture registrationFuture = (CompletableFuture)ch.attr(WebSocketClient.REGISTRATION_FUTURE).get();
            if (httpResponse.headers().contains((CharSequence)HttpHeaderNames.UPGRADE, (CharSequence)HttpHeaderValues.WEBSOCKET, true) && !this.handshaker.isHandshakeComplete()) {
                this.handshaker.finishHandshake(ch, httpResponse);
                registrationFuture.complete(this.clientId);
                if (LOG.isTraceEnabled()) {
                    LOG.trace("web socket client {} connected", (Object)this.clientId);
                }
                if (LOG.isTraceEnabled()) {
                    ch.pipeline().addFirst(new ChannelHandler[]{new LoggingHandler(WebSocketClient.class.getName() + "-first")});
                }
            } else if (httpResponse.status().equals((Object)HttpResponseStatus.NOT_IMPLEMENTED)) {
                String message = this.readRequestBody(httpResponse);
                registrationFuture.completeExceptionally(new WebSocketException(message));
                if (LOG.isWarnEnabled()) {
                    LOG.warn(message);
                }
            } else if (httpResponse.status().equals((Object)HttpResponseStatus.RESET_CONTENT)) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Web socket client not required MockServer in same JVM as client");
                }
                registrationFuture.complete(this.clientId);
            } else {
                registrationFuture.completeExceptionally(new WebSocketException("handshake failure unsupported message received " + String.valueOf(new FullHttpResponseToMockServerHttpResponse().mapFullHttpResponseToMockServerResponse(httpResponse))));
                if (LOG.isWarnEnabled()) {
                    LOG.warn("web socket client handshake handler received an unsupported FullHttpResponse message {}", msg);
                }
            }
        } else if (msg instanceof WebSocketFrame) {
            WebSocketFrame frame = (WebSocketFrame)msg;
            if (frame instanceof TextWebSocketFrame) {
                TextWebSocketFrame txtFrame = (TextWebSocketFrame)frame;
                this.webSocketClient.receivedTextWebSocketFrame(txtFrame);
            } else if (frame instanceof PingWebSocketFrame) {
                ctx.write((Object)new PongWebSocketFrame(frame.content().retain()));
            } else if (frame instanceof CloseWebSocketFrame) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Web socket client received request to close");
                }
                ch.close();
            } else if (LOG.isWarnEnabled()) {
                LOG.warn("Web socket client received an unsupported WebSocketFrame message {}", msg);
            }
        } else if (LOG.isWarnEnabled()) {
            LOG.warn("Web socket client received a message of unknown type {}", msg);
        }
    }

    private String readRequestBody(FullHttpResponse fullHttpResponse) {
        if (fullHttpResponse.content().readableBytes() > 0) {
            byte[] bodyBytes = new byte[fullHttpResponse.content().readableBytes()];
            fullHttpResponse.content().readBytes(bodyBytes);
            MediaType mediaType = MediaType.parse(fullHttpResponse.headers().get((CharSequence)HttpHeaderNames.CONTENT_TYPE));
            return new String(bodyBytes, mediaType.getCharsetOrDefault());
        }
        return "";
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        LOG.error("Web socket client caught exception", cause);
        CompletableFuture registrationFuture = (CompletableFuture)ctx.channel().attr(WebSocketClient.REGISTRATION_FUTURE).get();
        if (!registrationFuture.isDone()) {
            registrationFuture.completeExceptionally(cause);
        }
        ctx.close();
    }
}

