/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.closurecallback.websocketclient;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URISyntaxException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.xdev.mockserver.closurecallback.websocketclient.WebSocketClientHandler;
import software.xdev.mockserver.closurecallback.websocketclient.WebSocketException;
import software.xdev.mockserver.logging.LoggingHandler;
import software.xdev.mockserver.mock.action.ExpectationCallback;
import software.xdev.mockserver.mock.action.ExpectationForwardAndResponseCallback;
import software.xdev.mockserver.model.HttpMessage;
import software.xdev.mockserver.model.HttpRequest;
import software.xdev.mockserver.model.HttpRequestAndHttpResponse;
import software.xdev.mockserver.model.HttpResponse;
import software.xdev.mockserver.serialization.WebSocketMessageSerializer;
import software.xdev.mockserver.serialization.model.WebSocketClientIdDTO;
import software.xdev.mockserver.serialization.model.WebSocketErrorDTO;

public class WebSocketClient<T extends HttpMessage> {
    private static final Logger LOG = LoggerFactory.getLogger(WebSocketClient.class);
    static final AttributeKey<CompletableFuture<String>> REGISTRATION_FUTURE = AttributeKey.valueOf((String)"REGISTRATION_FUTURE");
    private Channel channel;
    private final WebSocketMessageSerializer webSocketMessageSerializer;
    private ExpectationCallback<T> expectationCallback;
    private ExpectationForwardAndResponseCallback expectationForwardResponseCallback;
    private boolean isStopped;
    private final EventLoopGroup eventLoopGroup;
    private final String clientId;
    public static final String CLIENT_REGISTRATION_ID_HEADER = "X-CLIENT-REGISTRATION-ID";

    public WebSocketClient(EventLoopGroup eventLoopGroup, String clientId) {
        this.eventLoopGroup = eventLoopGroup;
        this.clientId = clientId;
        this.webSocketMessageSerializer = new WebSocketMessageSerializer();
    }

    private Future<String> register(final InetSocketAddress serverAddress, final String contextPath, int reconnectAttempts) {
        CompletableFuture<String> registrationFuture = new CompletableFuture<String>();
        try {
            ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(this.eventLoopGroup)).channel(NioSocketChannel.class)).attr(REGISTRATION_FUTURE, registrationFuture)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel ch) throws URISyntaxException {
                    ch.pipeline().addLast(new ChannelHandler[]{new HttpClientCodec()});
                    ch.pipeline().addLast(new ChannelHandler[]{new HttpObjectAggregator(Integer.MAX_VALUE)});
                    ch.pipeline().addLast(new ChannelHandler[]{new WebSocketClientHandler(WebSocketClient.this.clientId, serverAddress, contextPath, WebSocketClient.this)});
                    if (LOG.isTraceEnabled()) {
                        ch.pipeline().addLast(new ChannelHandler[]{new LoggingHandler(WebSocketClient.class.getName() + "-last")});
                    }
                }
            })).connect((SocketAddress)serverAddress).addListener((GenericFutureListener)((ChannelFutureListener)connectChannelFuture -> {
                this.channel = connectChannelFuture.channel();
                this.channel.closeFuture().addListener((GenericFutureListener)((ChannelFutureListener)closeChannelFuture -> {
                    if (!this.isStopped && reconnectAttempts > 0) {
                        this.register(serverAddress, contextPath, reconnectAttempts - 1);
                    }
                }));
            }));
        }
        catch (Exception e) {
            registrationFuture.completeExceptionally(new WebSocketException("Exception while starting web socket client", e));
        }
        return registrationFuture;
    }

    void receivedTextWebSocketFrame(TextWebSocketFrame textWebSocketFrame) {
        block17: {
            try {
                Object deserializedMessage = this.webSocketMessageSerializer.deserialize(textWebSocketFrame.text());
                if (deserializedMessage instanceof HttpRequest) {
                    HttpRequest request = (HttpRequest)deserializedMessage;
                    String webSocketCorrelationId = request.getFirstHeader("WebSocketCorrelationId");
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Received request {} over websocket for client {} for correlationId {}", new Object[]{request, this.clientId, webSocketCorrelationId});
                    }
                    if (this.expectationCallback != null) {
                        try {
                            T result = this.expectationCallback.handle(request);
                            if (LOG.isTraceEnabled()) {
                                LOG.trace("Returning response {} for request {} over websocket for client {} for correlationId {}", new Object[]{result, request, this.clientId, webSocketCorrelationId});
                            }
                            result.withHeader("WebSocketCorrelationId", webSocketCorrelationId);
                            this.channel.writeAndFlush((Object)new TextWebSocketFrame(this.webSocketMessageSerializer.serialize(result)));
                        }
                        catch (Exception ex) {
                            LOG.error("Exception thrown while handling callback for request", (Throwable)ex);
                            this.channel.writeAndFlush((Object)new TextWebSocketFrame(this.webSocketMessageSerializer.serialize(new WebSocketErrorDTO().setMessage(ex.getMessage()).setWebSocketCorrelationId(webSocketCorrelationId))));
                        }
                    }
                    break block17;
                }
                if (deserializedMessage instanceof HttpRequestAndHttpResponse) {
                    HttpRequestAndHttpResponse httpRequestAndHttpResponse = (HttpRequestAndHttpResponse)deserializedMessage;
                    HttpRequest httpRequest = httpRequestAndHttpResponse.getHttpRequest();
                    HttpResponse httpResponse = httpRequestAndHttpResponse.getHttpResponse();
                    String webSocketCorrelationId = httpRequest.getFirstHeader("WebSocketCorrelationId");
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Received request and response {} over websocket for client {} for correlationId {}", new Object[]{httpResponse, this.clientId, webSocketCorrelationId});
                    }
                    if (this.expectationForwardResponseCallback != null) {
                        try {
                            HttpResponse response = this.expectationForwardResponseCallback.handle(httpRequest, httpResponse);
                            if (LOG.isTraceEnabled()) {
                                LOG.trace("Returning response {} for request and response {} over websocket for client {} for correlationId {}", new Object[]{response, httpRequestAndHttpResponse, this.clientId, webSocketCorrelationId});
                            }
                            response.withHeader("WebSocketCorrelationId", webSocketCorrelationId);
                            this.channel.writeAndFlush((Object)new TextWebSocketFrame(this.webSocketMessageSerializer.serialize(response)));
                        }
                        catch (Exception ex) {
                            LOG.error("Exception thrown while handling callback for request and response", (Throwable)ex);
                            this.channel.writeAndFlush((Object)new TextWebSocketFrame(this.webSocketMessageSerializer.serialize(new WebSocketErrorDTO().setMessage(ex.getMessage()).setWebSocketCorrelationId(webSocketCorrelationId))));
                        }
                    }
                    break block17;
                }
                if (deserializedMessage instanceof WebSocketClientIdDTO) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Received client id {}", deserializedMessage);
                    }
                    break block17;
                }
                if (LOG.isWarnEnabled()) {
                    LOG.trace("Web socket client received a message that isn't HttpRequest or HttpRequestAndHttpResponse {} which has been deserialized as {}", (Object)textWebSocketFrame.text(), deserializedMessage);
                }
                throw new WebSocketException("Unsupported web socket message " + textWebSocketFrame.text());
            }
            catch (Exception e) {
                throw new WebSocketException("Exception while receiving web socket message", e);
            }
        }
    }

    public void stopClient() {
        this.isStopped = true;
        try {
            if (this.eventLoopGroup != null && !this.eventLoopGroup.isShuttingDown()) {
                this.eventLoopGroup.shutdownGracefully();
            }
            if (this.channel != null && this.channel.isOpen()) {
                this.channel.close().sync();
                this.channel = null;
            }
        }
        catch (InterruptedException e) {
            throw new WebSocketException("Exception while closing client", e);
        }
    }

    public Future<String> registerExpectationCallback(ExpectationCallback<T> expectationCallback, ExpectationForwardAndResponseCallback expectationForwardResponseCallback, InetSocketAddress serverAddress, String contextPath) {
        if (this.expectationCallback == null) {
            this.expectationCallback = expectationCallback;
            this.expectationForwardResponseCallback = expectationForwardResponseCallback;
            return this.register(serverAddress, contextPath, 3);
        }
        throw new IllegalArgumentException("It is not possible to set response callback once a forward callback has been set");
    }
}

